/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.sg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.piax.common.Endpoint;
import org.piax.common.subspace.Range;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeObserver;
import org.piax.gtrans.ov.sg.MembershipVector;
import org.piax.gtrans.ov.sg.NoSuchKeyException;
import org.piax.gtrans.ov.sg.RQMessage;
import org.piax.gtrans.ov.sg.RangeUtils;
import org.piax.gtrans.ov.sg.SkipGraph;
import org.piax.gtrans.ov.sg.SkipGraphIf;
import org.piax.gtrans.ov.sg.TemporaryIOException;
import org.piax.gtrans.ov.sg.UnavailableException;
import org.piax.util.UniqId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SGNode<E extends Endpoint>
implements NodeObserver {
    private static final Logger logger = LoggerFactory.getLogger(SGNode.class);
    private static int MAX_RETRY = 10;
    private static int INSERTION_RETRY_PERIOD = 100;
    private static int MAX_INSERTION_RETRY_PERIOD = 15000;
    private static int TRAVERSAL_RETRY_PERIOD = 1000;
    final SkipGraph<E> sg;
    final ArrayList<Tile> table = new ArrayList();
    final Comparable<?> rawkey;
    final DdllKey key;
    private final MembershipVector mv;
    SGMode sgmode = SGMode.OUT;
    private int traversed = 0;
    final Set<SkipGraph.QueryId> queryHistory = new HashSet<SkipGraph.QueryId>();

    public SGNode(SkipGraph<E> sg, MembershipVector mv, Comparable<?> rawkey) {
        this.sg = sg;
        this.mv = mv;
        this.rawkey = rawkey;
        this.key = new DdllKey(rawkey, new UniqId(sg.peerId));
    }

    private void rtLockR() {
        this.sg.rtLockR();
    }

    private void rtUnlockR() {
        this.sg.rtUnlockR();
    }

    private void rtLockW() {
        this.sg.rtLockW();
    }

    private void rtUnlockW() {
        this.sg.rtUnlockW();
    }

    boolean addKey(E seed) throws UnavailableException, IOException {
        logger.trace("ENTRY:");
        logger.debug("insert key {} seed:{}", this.rawkey, seed);
        if (this.rawkey == null) {
            throw new IllegalArgumentException("null key specified");
        }
        this.rtLockW();
        assert (this.sgmode == SGMode.OUT);
        this.sgmode = SGMode.TRAVERSING;
        this.rtUnlockW();
        long start = System.currentTimeMillis();
        int retryAll = 0;
        long retryWait = INSERTION_RETRY_PERIOD;
        int retryCounter = 0;
        int l = 0;
        while (true) {
            long travTime;
            long end0;
            Tile t = this.getDdllNode(l, SkipGraph.LvState.INSERTING);
            Node n = t.node;
            long start0 = System.currentTimeMillis();
            try {
                Node.InsertPoint p = this.getContact(seed, l);
                end0 = System.currentTimeMillis();
                travTime = end0 - start0;
                if (p == null) {
                    this.rtLockW();
                    if (this.sgmode != SGMode.TRAVERSING) {
                        this.rtUnlockW();
                        throw new ConflictException("conflict");
                    }
                    n.insertAsInitialNode();
                    t.mode = SkipGraph.LvState.INSERTED;
                    if (l + 1 >= this.sg.getHeight()) break;
                    logger.warn("{}:cont l={} height={}", new Object[]{this.key, l, this.sg.getHeight()});
                    ++l;
                    retryCounter = 0;
                    this.rtUnlockW();
                    continue;
                }
                logger.debug("{} is inserting at level {} between {}", new Object[]{this.rawkey, l, p});
                assert (t.mode == SkipGraph.LvState.INSERTING);
                Node.InsertionResult insres = null;
                if (t.node.isBetween(p.left.key, p.right.key)) {
                    insres = n.insert(p);
                } else {
                    logger.debug("{}: not ordered: {}", this.rawkey, (Object)p);
                    insres = n.insert(p.left, 1);
                }
                if (insres.success) {
                    t.mode = SkipGraph.LvState.INSERTED;
                    logger.debug("{} is inserted at level {}, retry = {}, travTime = {}msec: {}", new Object[]{this.rawkey, l, retryCounter, travTime, n});
                    logger.debug(this.sg.toString());
                    ++l;
                    retryCounter = 0;
                    if (!n.getMyLink().addr.equals(n.getRight().addr) || !n.getMyLink().addr.equals(n.getLeft().addr)) continue;
                    logger.debug("leftaddr == myaddr == rightaddr, l={}, h={}", (Object)l, (Object)this.sg.getHeight());
                    this.rtLockW();
                    if (l >= this.sg.getHeight()) break;
                    this.rtUnlockW();
                    continue;
                }
                logger.debug("{}: DDLL insertion failed at level {}, retry.", this.rawkey, (Object)l);
                this.rtLockW();
                this.sgmode = SGMode.WAITING;
                this.rtUnlockW();
            }
            catch (ConflictException e) {
                end0 = System.currentTimeMillis();
                travTime = end0 - start0;
                logger.debug("addKey: got {}, travTime = {}msec, waiting...", (Object)e, (Object)travTime);
            }
            catch (TemporaryIOException e) {
                this.sgmode = SGMode.WAITING;
                end0 = System.currentTimeMillis();
                travTime = end0 - start0;
                logger.debug("addKey: got {}, travTime = {}msec, waiting...", (Object)e, (Object)travTime);
            }
            catch (UnavailableException e) {
                logger.debug("", (Throwable)e);
                if (l == 0) {
                    if (seed == null) {
                        n.insertAsInitialNode();
                        t.mode = SkipGraph.LvState.INSERTED;
                        this.rtLockW();
                        this.sgmode = SGMode.INSERTED;
                        this.rtUnlockW();
                        logger.debug("inserted as the initial node");
                        return true;
                    }
                    throw e;
                }
                throw new Error("addKey: got UnavailableException while l != 0");
            }
            this.rtLockR();
            assert (this.sgmode == SGMode.WAITING);
            this.rtUnlockR();
            ++retryAll;
            ++retryCounter;
            try {
                long waitTime = retryWait + (long)((double)retryWait * Math.random());
                if ((retryWait <<= 1) > (long)MAX_INSERTION_RETRY_PERIOD) {
                    retryWait = INSERTION_RETRY_PERIOD;
                }
                logger.debug("{}: {}th retry after {}ms", new Object[]{this.rawkey, retryCounter, waitTime});
                Thread.sleep(waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("{}: waiting done at level {}", this.rawkey, (Object)l);
        }
        assert (this.sg.rtlock.writeLock().isHeldByCurrentThread());
        this.sgmode = SGMode.INSERTED;
        this.rtUnlockW();
        long end = System.currentTimeMillis();
        logger.debug("addKey({}) took {} msec, total retry count = {}", new Object[]{this.rawkey, end - start, retryAll});
        return true;
    }

    private Node.InsertPoint getContact(E seed, int l) throws UnavailableException, IOException, ConflictException {
        if (l == 0) {
            try {
                Node.InsertPoint p = this.sg.find(seed, new DdllKey(this.rawkey, new UniqId(this.sg.peerId)), false);
                logger.debug("getContact: {} is between {} at level0", this.rawkey, (Object)p);
                return p;
            }
            catch (UnavailableException e) {
                logger.debug("", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
                throw e;
            }
        }
        try {
            Node.InsertPoint p = this.findMatchingNode(l);
            logger.debug("getContact: {} returns {} at level {}", new Object[]{this.rawkey, p, l});
            return p;
        }
        catch (ConflictException e) {
            logger.debug("", (Throwable)e);
            throw e;
        }
        catch (NoSuchKeyException e) {
            logger.debug("", (Throwable)e);
            throw new Error("should not happen", e);
        }
        catch (IOException e) {
            logger.debug("", (Throwable)e);
            throw new Error("should not happen", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeKey() {
        this.rtLockW();
        if (this.sgmode != SGMode.INSERTED) {
            this.rtUnlockW();
            return false;
        }
        this.sgmode = SGMode.DELETING;
        this.rtUnlockW();
        for (int i = this.table.size() - 1; i >= 0; --i) {
            Node n = this.getTile((int)i).node;
            logger.debug("removeKey: {}, level {}", (Object)n, (Object)i);
            boolean rc = n.delete(MAX_RETRY);
            if (!rc) {
                logger.info("removeKey: ddll node deletion fails");
            }
            this.rtLockW();
            try {
                this.table.remove(i);
                continue;
            }
            finally {
                this.rtUnlockW();
            }
        }
        this.rtLockW();
        this.sgmode = SGMode.OUT;
        this.rtUnlockW();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    SkipGraph.BestLink findClosestLocal(DdllKey key, boolean accurate) {
        logger.debug("findClosestLocal: key {}", (Object)key);
        assert (this.sg.rtlock.getReadHoldCount() > 0);
        if (this.sgmode == SGMode.OUT) {
            throw new Error("findClosestLocal is called while sgmode==OUT");
        }
        SkipGraph.BestLink best = null;
        for (int l = this.table.size() - 1; l >= 0; --l) {
            Tile t = this.getTile(l);
            if (t == null) continue;
            Node n = t.node;
            n.lock();
            try {
                if (n.getMode() != Node.Mode.IN && n.getMode() != Node.Mode.DELWAIT) continue;
                Link leftLink = n.getLeft();
                Link rightLink = n.getRight();
                Link myLink = n.getMyLink();
                if (best == null || Node.isOrdered(best.link.key, rightLink.key, key)) {
                    best = new SkipGraph.BestLink(rightLink, null, false);
                }
                if (Node.isOrdered(best.link.key, leftLink.key, key)) {
                    best = new SkipGraph.BestLink(leftLink, null, false);
                }
                if (Node.isOrdered(best.link.key, myLink.key, key)) {
                    best = new SkipGraph.BestLink(myLink, null, false);
                }
                if (Node.isOrdered(best.link.key, rightLink.key, key)) {
                    best = new SkipGraph.BestLink(rightLink, null, false);
                }
                if (l != 0) continue;
                if (Node.isOrdered(myLink.key, key, rightLink.key)) {
                    best = new SkipGraph.BestLink(myLink, rightLink, true);
                    continue;
                }
                if (!Node.isOrdered(leftLink.key, key, myLink.key) || Node.isOrdered(leftLink.key, best.link.key, myLink.key)) continue;
                best = new SkipGraph.BestLink(leftLink, myLink, !accurate);
                continue;
            }
            finally {
                n.unlock();
            }
        }
        logger.debug("best {}", best);
        return best;
    }

    private Node.InsertPoint findMatchingNode(int level) throws NoSuchKeyException, ConflictException, IOException {
        this.rtLockW();
        this.sgmode = SGMode.TRAVERSING;
        this.traversed = 0;
        this.rtUnlockW();
        try {
            Node.InsertPoint p = this.findMatchingNode0(level);
            logger.debug("FMN: finished after traversing {} nodes", (Object)this.traversed);
            return p;
        }
        catch (ConflictException e) {
            this.rtLockW();
            this.sgmode = SGMode.WAITING;
            this.rtUnlockW();
            throw e;
        }
    }

    private Node.InsertPoint findMatchingNode0(int level) throws NoSuchKeyException, ConflictException, IOException {
        assert (level > 0);
        Node mine = this.getDdllNode((int)(level - 1), null).node;
        Link n = mine.getRight();
        while (true) {
            SkipGraph.SGNodeInfo inf;
            if (this.sgmode != SGMode.TRAVERSING) {
                logger.debug("FMN: seems conflicted. stop scanning");
                throw new ConflictException("i lost");
            }
            mine = this.getDdllNode((int)(level - 1), null).node;
            logger.debug("FMN: n={}, mine={}, level={}", new Object[]{n, mine, level});
            if (mine.getMyLink().equals(n)) {
                logger.debug("findMatchingNode: circulated");
                return null;
            }
            SkipGraphIf stub = (SkipGraphIf)this.sg.getStub(n.addr, SkipGraph.RPC_TIMEOUT);
            try {
                logger.debug("findMatchingNode: calling getSGNodeInfo on {}", (Object)n);
                inf = stub.getSGNodeInfo(n.key.getPrimaryKey(), level - 1, this.mv, this.traversed);
                if (inf == null) {
                    logger.debug("findMatchingNode: inf==null, retry");
                    throw new ConflictException("findMatchingNode: inf==null");
                }
                logger.debug("findMatchingNode: got {}", (Object)inf);
            }
            catch (NoSuchKeyException e) {
                logger.debug("", (Throwable)e);
                logger.debug("findMatchingNode: retry after " + TRAVERSAL_RETRY_PERIOD + " msec");
                throw new ConflictException(e.toString());
            }
            catch (RPCException e) {
                logger.debug("RPCEx:", e.getCause());
                throw new ConflictException("RPC to " + n + ", " + e.getCause());
            }
            if (!inf.proceedRight()) {
                if (inf.foundInserted()) {
                    logger.debug("findMatchingNode: found {} at level {} for key {}", new Object[]{inf.me, level, this.rawkey});
                    return new Node.InsertPoint(inf.left, inf.me);
                }
                throw new ConflictException("conflicted with node " + n + " and I lost");
            }
            logger.debug("{}: move right {}", this.rawkey, (Object)inf);
            this.rtLockW();
            ++this.traversed;
            this.rtUnlockW();
            if (Node.isOrdered(n.key, this.key, inf.right.key) && this.key.compareTo(inf.right.key) != 0) {
                logger.warn("FMN: circulated without visiting myself");
                return null;
            }
            n = inf.right;
            logger.debug("findMatchingNode: move to the right");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SkipGraph.SGNodeInfo getSGNodeInfo(int level, MembershipVector mv, int nTraversed) {
        logger.debug("getSGNodeInfo(this={}, level={}, nTraversed={})", new Object[]{this, level, nTraversed});
        this.rtLockW();
        try {
            Link r;
            Tile tile = this.getTile(level);
            if (tile == null) {
                logger.info("getSGNodeInfo: no such level ({})", (Object)level);
                SkipGraph.SGNodeInfo sGNodeInfo = null;
                return sGNodeInfo;
            }
            Node n = tile.node;
            n.lock();
            try {
                if (n.getMode() == Node.Mode.OUT) {
                    logger.info("getSGNodeInfo: no such level ({})", (Object)level);
                    SkipGraph.SGNodeInfo sGNodeInfo = null;
                    return sGNodeInfo;
                }
                r = n.getRight();
            }
            finally {
                n.unlock();
            }
            if (this.mv.commonPrefixLen(mv) < level + 1) {
                logger.debug("getSGNodeInfo: non-matching node");
                SkipGraph.SGNodeInfo sGNodeInfo = new SkipGraph.SGNodeInfo(null, null, r);
                return sGNodeInfo;
            }
            Link left = null;
            Link myLink = null;
            Link right = null;
            Tile uplevel = this.getTile(level + 1);
            if (uplevel == null && this.sgmode == SGMode.INSERTED) {
                uplevel = this.getDdllNode(level + 1, SkipGraph.LvState.INSERTED);
            }
            if (uplevel != null) {
                Node x = uplevel.node;
                x.lock();
                block6 : switch (uplevel.mode) {
                    case INSERTED: {
                        left = x.getLeft();
                        myLink = x.getMyLink();
                        break;
                    }
                    case INSERTING: {
                        switch (this.sgmode) {
                            case WAITING: {
                                right = r;
                                break;
                            }
                            case TRAVERSING: {
                                boolean proceedOK = nTraversed > this.traversed;
                                logger.debug("getSGNodeInfo: conflicts. proceedOK = {}", (Object)proceedOK);
                                if (!proceedOK) break block6;
                                right = r;
                                this.sgmode = SGMode.WAITING;
                                break;
                            }
                            default: {
                                logger.info("getSGNodeInfo: sgmode = {}", (Object)this.sgmode);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        logger.info("getSGNodeInfo: uplevel.mode = {}", (Object)uplevel.mode);
                        right = r;
                    }
                }
                x.unlock();
            }
            SkipGraph.SGNodeInfo sGNodeInfo = new SkipGraph.SGNodeInfo(myLink, left, right);
            return sGNodeInfo;
        }
        finally {
            this.rtUnlockW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tile getDdllNode(int level, SkipGraph.LvState newstate) {
        this.rtLockW();
        try {
            if (level < this.table.size()) {
                Tile tile = this.table.get(level);
                return tile;
            }
            assert (newstate != null);
            this.sg.adjustHeight(level);
            if (newstate == SkipGraph.LvState.INSERTED && this.sgmode != SGMode.TRAVERSING) {
                Tile tile = this.table.get(level);
                return tile;
            }
            Node n = this.createDdllNode(level);
            if (newstate == SkipGraph.LvState.INSERTED && this.sgmode == SGMode.TRAVERSING) {
                n.insertAsInitialNode();
            }
            Tile t = new Tile(n, newstate);
            this.table.add(level, t);
            Tile tile = t;
            return tile;
        }
        finally {
            this.rtUnlockW();
        }
    }

    Node createDdllNode(int level) {
        Node n = this.sg.manager.createNode(this.rawkey, "L" + level, this, this.sg.mv);
        if (level == 0) {
            n.setCheckPeriod(SkipGraph.DDLL_CHECK_PERIOD_L0);
        } else {
            n.setCheckPeriod(SkipGraph.DDLL_CHECK_PERIOD_L1);
        }
        return n;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Comparable<?> k = this.rawkey;
        buf.append("key=" + k);
        if (k != null) {
            buf.append(" (" + k.getClass().getCanonicalName() + ")\n");
        } else {
            buf.append("\n");
        }
        buf.append("sgmode=" + (Object)((Object)this.sgmode) + "\n");
        if (this.table != null) {
            for (int i = this.table.size() - 1; i >= 0; --i) {
                try {
                    buf.append(" lv" + i + ": " + this.table.get(i) + "\n");
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return buf.toString();
    }

    public Tile getTile(int level) {
        this.rtLockR();
        try {
            if (this.table.size() <= level) {
                Tile tile = null;
                return tile;
            }
            Tile tile = this.table.get(level);
            return tile;
        }
        finally {
            this.rtUnlockR();
        }
    }

    int getInsertedHeight() {
        int l;
        assert (this.sg.rtlock.getReadHoldCount() > 0);
        for (l = 0; l < this.table.size(); ++l) {
            Tile t = this.table.get(l);
            if (t.mode != SkipGraph.LvState.INSERTED) break;
        }
        return l;
    }

    Link getMyLinkAtLevel0() {
        Tile t = this.getTile(0);
        if (t == null) {
            return null;
        }
        return t.node.getMyLink();
    }

    Link getRightAtLevel0() {
        return this.table.get((int)0).node.getRight();
    }

    Set<Link> getAllLinks(boolean insertedOnly) {
        HashSet<Link> set = new HashSet<Link>();
        for (int i = this.table.size() - 1; i >= 0; --i) {
            Link left;
            Tile t = this.table.get(i);
            if (t.mode != SkipGraph.LvState.INSERTED && (insertedOnly || t.mode != SkipGraph.LvState.INSERTING) || (left = t.node.getLeft()) == null) continue;
            Link right = t.node.getRight();
            Link me = t.node.getMyLink();
            set.add(left);
            if (right != null) {
                set.add(right);
            }
            if (me == null) continue;
            set.add(me);
        }
        return set;
    }

    Set<Link> getAllLeftLinks() {
        HashSet<Link> set = new HashSet<Link>();
        for (int i = this.getInsertedHeight() - 1; i >= 0; --i) {
            Tile t = this.getTile(i);
            set.add(t.node.getLeft());
            set.add(t.node.getMyLink());
        }
        return set;
    }

    Link getLeftLink(int level) {
        Tile t = this.getTile(level);
        return t.node.getLeft();
    }

    Link getRightLink(int level) {
        Tile t = this.getTile(level);
        return t.node.getRight();
    }

    Set<Link> getAllRightLinks() {
        HashSet<Link> set = new HashSet<Link>();
        for (int i = this.getInsertedHeight() - 1; i >= 0; --i) {
            Tile t = this.getTile(i);
            set.add(t.node.getRight());
            set.add(t.node.getMyLink());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixLeftLinks(Link failedLink, Collection<Link> failedLinks, RQMessage<E> parentMsg, Collection<Range<DdllKey>> failedRanges) {
        String h = "fixLeftLinks@" + this.sg.myLocator;
        logger.debug("{}: failedLink = {}, failedLinks = {}, failedRanges = {}", new Object[]{h, failedLink, failedLinks, failedRanges});
        RQMessage<E> msg = null;
        if (parentMsg != null && !failedRanges.isEmpty()) {
            msg = parentMsg.newChildInstance(failedRanges, "fixLeftLinks@" + this.key);
        }
        this.rtLockR();
        try {
            for (int level = this.getInsertedHeight() - 1; level >= 0; --level) {
                Tile tile = this.getTile(level);
                Link left = tile.node.getLeft();
                if (left == null || failedLink.compareTo(left) != 0) continue;
                if (level == 0 && parentMsg != null) {
                    if (!failedRanges.isEmpty()) {
                        logger.debug("{}: fix at L0, childmsg = {}", (Object)h, msg);
                        msg.prepareReceivingReply();
                        tile.node.startfix(failedLinks, msg);
                        msg = null;
                    } else {
                        logger.debug("{}: fix at L0, no childmsg", (Object)h);
                        tile.node.startFix(failedLinks);
                    }
                    this.propagateRightward(left, failedLinks, this.key);
                    continue;
                }
                logger.debug("{}: fix at L{}", (Object)h, (Object)level);
                tile.node.startFix(failedLinks);
            }
        }
        finally {
            this.rtUnlockR();
        }
        if (msg != null) {
            logger.info("{}: failed link not found: {}", (Object)h, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixAndPropagateRight(Link failedLink, Collection<Link> failedLinks, DdllKey rLimit) {
        String h = "fixAndPropagateRight@" + this.sg.myLocator;
        logger.debug("{}: failedLink = {}, failedLinks = {}, rLimit = {}", new Object[]{h, failedLink, failedLinks, rLimit});
        this.rtLockR();
        try {
            for (int level = this.getInsertedHeight() - 1; level >= 0; --level) {
                Link left;
                Tile tile = this.getTile(level);
                if (tile.mode != SkipGraph.LvState.INSERTED || failedLink.compareTo(left = tile.node.getLeft()) != 0) continue;
                logger.debug("{}: fix at L{}", (Object)h, (Object)level);
                tile.node.startFix(failedLinks);
            }
            this.propagateRightward(failedLink, failedLinks, rLimit);
        }
        finally {
            this.rtUnlockR();
        }
    }

    private void propagateRightward(Link failedLink, Collection<Link> failedLinks, DdllKey rLimit) {
        String h = "propagateRightward@" + this.sg.myLocator;
        MembershipVector mvec = (MembershipVector)failedLink.key.appData;
        int level = mvec.commonPrefixLen(this.sg.mv);
        Tile tile = this.getTile(level);
        if (tile == null) {
            logger.debug("{}: forward right stops at L{} (tile is null)", (Object)h, (Object)level);
            return;
        }
        Link right = tile.node.getRight();
        if (right == null) {
            logger.debug("{}: forward right stops at L{} (right is null)", (Object)h, (Object)level);
            return;
        }
        if (!failedLinks.contains(right) && right.key.compareTo(this.key) != 0) {
            if (rLimit != null && this.key.compareTo(rLimit) != 0 && Node.isOrdered(this.key, rLimit, right.key)) {
                logger.debug("rLimit restricted");
                return;
            }
            try {
                SkipGraphIf stub = (SkipGraphIf)this.sg.getStub(right.addr);
                logger.debug("{}: forward right {} at L{}", new Object[]{h, right, level});
                stub.fixAndPropagateSingle(right.key.getPrimaryKey(), failedLink, failedLinks, rLimit);
            }
            catch (RPCException e) {
                logger.info("", (Throwable)e);
            }
        } else {
            logger.debug("{}: forward right stops at L{}", (Object)h, (Object)level);
        }
    }

    @Override
    public void onRightNodeChange(Link prevRight, Link newRight, Object payload) {
        if (payload == null) {
            return;
        }
        logger.debug("{}: rightNodeChanged from {} to {}, {}", new Object[]{this.key, prevRight, newRight, payload});
        if (payload instanceof RQMessage) {
            RQMessage msg = (RQMessage)payload;
            msg.sgmf = this.sg.sgmf;
            ArrayList<Range<DdllKey>> subRanges = new ArrayList<Range<DdllKey>>();
            for (Range<DdllKey> r : msg.subRanges) {
                if (!RangeUtils.hasCommon(r, this.key, newRight.key)) continue;
                subRanges.add(r);
            }
            logger.debug("{}: rightNodeChanged: {} => {}", new Object[]{this.key, msg.subRanges, subRanges});
            RQMessage msg2 = msg.newInstanceSubrangesChanged(subRanges);
            this.sg.rqDisseminate(msg2);
        } else {
            logger.warn("{}: rightNodeChanged received illgal payload {}", (Object)this.key, payload);
        }
    }

    @Override
    public void payloadNotSent(Object payload) {
        if (payload instanceof RQMessage) {
            RQMessage msg = (RQMessage)payload;
            logger.debug("{}: payloadNotSent: {}", (Object)this.key, (Object)msg);
            this.sg.rqDisseminate(msg);
        } else {
            logger.warn("{}: payloadNotSent received illgal payload {}", (Object)this.key, payload);
        }
    }

    @Override
    public boolean onNodeFailure(Collection<Link> failedLinks) {
        logger.debug("onNodeFailure: {}", failedLinks);
        for (Link flink : failedLinks) {
            this.fixAndPropagateRight(flink, failedLinks, this.key);
        }
        logger.debug("onNodeFailure finished");
        return false;
    }

    @Override
    public List<Link> suppplyLeftCandidatesForFix() {
        return null;
    }

    static class ConflictException
    extends Exception {
        public ConflictException(String msg) {
            super(msg);
        }
    }

    public static class Tile {
        public Node node;
        SkipGraph.LvState mode;

        public Tile(Node node, SkipGraph.LvState mode) {
            this.node = node;
            this.mode = mode;
        }

        public String toString() {
            return "[" + (Object)((Object)this.mode) + ", " + this.node + "]";
        }
    }

    static enum SGMode {
        OUT,
        TRAVERSING,
        WAITING,
        INSERTED,
        DELETING;

    }
}

