/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.sg;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.RPCInvoker;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeManager;
import org.piax.gtrans.ov.ddll.NodeManagerIf;
import org.piax.gtrans.ov.sg.DdllKeyRange;
import org.piax.gtrans.ov.sg.MembershipVector;
import org.piax.gtrans.ov.sg.NoSuchKeyException;
import org.piax.gtrans.ov.sg.RQMessage;
import org.piax.gtrans.ov.sg.RQReturn;
import org.piax.gtrans.ov.sg.RangeUtils;
import org.piax.gtrans.ov.sg.SGExecQueryCallback;
import org.piax.gtrans.ov.sg.SGMessagingFramework;
import org.piax.gtrans.ov.sg.SGNode;
import org.piax.gtrans.ov.sg.SkipGraphIf;
import org.piax.gtrans.ov.sg.TemporaryIOException;
import org.piax.gtrans.ov.sg.UnavailableException;
import org.piax.util.KeyComparator;
import org.piax.util.MersenneTwister;
import org.piax.util.StrictMap;
import org.piax.util.UniqId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipGraph<E extends Endpoint>
extends RPCInvoker<SkipGraphIf<E>, E>
implements SkipGraphIf<E> {
    private static final Logger logger = LoggerFactory.getLogger(SkipGraph.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("sg");
    NodeManager manager;
    E myLocator;
    final PeerId peerId;
    final MembershipVector mv;
    ReentrantReadWriteLock rtlock = new ReentrantReadWriteLock();
    private static final KeyComparator keyComp = KeyComparator.getInstance();
    NavigableMap<Comparable<?>, SGNode<E>> keyHash = new ConcurrentSkipListMap(keyComp);
    private Random rand = new MersenneTwister();
    final SGExecQueryCallback execQueryCallback;
    final Timer timer;
    public static int DDLL_CHECK_PERIOD_L0 = 10000;
    public static int DDLL_CHECK_PERIOD_L1 = 30000;
    public static int RQ_NRECENT = 10;
    public static int RPC_TIMEOUT = 20000;
    public static int QID_EXPIRE = 120000;
    public static int QID_EXPIRATION_TASK_PERIOD = 20000;
    final SGMessagingFramework<E> sgmf;
    public static int RQ_FLUSH_PERIOD = 2000;
    public static int RQ_EXPIRATION_GRACE = 5000;
    public static int RQ_RETRANS_PERIOD = 10000;
    public static String QUERY_INSERT_POINT_SPECIAL = "*InsertPointSpecial*";
    public static int FIND_INSERT_POINT_TIMEOUT = 30000;
    private static final UniqId FIXPEERID = UniqId.PLUS_INFINITY;
    private final Link FIXLEFT;

    public SkipGraph(ChannelTransport<E> trans, SGExecQueryCallback execQueryCallback) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, trans, execQueryCallback);
    }

    public SkipGraph(TransportId transId, ChannelTransport<E> trans, SGExecQueryCallback execQueryCallback) throws IdConflictException, IOException {
        super(transId, trans);
        this.myLocator = trans.getEndpoint();
        this.peerId = trans.getPeerId();
        this.mv = new MembershipVector();
        this.manager = new NodeManager(new TransportId(transId.toString() + "-ddll"), trans);
        this.execQueryCallback = execQueryCallback;
        logger.debug("SkipGraph: transId={}", (Object)trans.getTransportId());
        this.timer = new Timer("SGTimer@" + this.myLocator, true);
        this.FIXLEFT = new Link((Endpoint)this.myLocator, new DdllKey(Integer.valueOf(0), FIXPEERID));
        this.sgmf = new SGMessagingFramework(this);
        this.timer.schedule((TimerTask)new PurgeTask(), (long)(Math.random() * (double)QID_EXPIRATION_TASK_PERIOD), (long)QID_EXPIRATION_TASK_PERIOD);
    }

    @Override
    public synchronized void fin() {
        this.manager.fin();
        this.sgmf.fin();
        super.fin();
    }

    public SGNode<E> getSGNode(Comparable<?> rawkey) {
        SGNode snode = (SGNode)this.keyHash.get(rawkey);
        return snode;
    }

    public PeerId getPeerId() {
        return this.peerId;
    }

    void rtLockR() {
        this.rtlock.readLock().lock();
    }

    void rtUnlockR() {
        this.rtlock.readLock().unlock();
    }

    void rtLockW() {
        this.rtlock.writeLock().lock();
    }

    void rtUnlockW() {
        this.rtlock.writeLock().unlock();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PeerId: " + this.peerId + "\n");
        buf.append("    mv: " + this.mv + "\n");
        for (SGNode snode : this.keyHash.values()) {
            buf.append(snode);
        }
        return buf.toString();
    }

    public String toStringShort() {
        return this.keyHash.keySet().toString();
    }

    public String showTable() {
        return this.toString();
    }

    private NavigableMap<DdllKey, Link> getAllLinks(boolean insertedOnly) {
        assert (this.rtlock.getReadLockCount() > 0 || this.rtlock.isWriteLockedByCurrentThread());
        ConcurrentSkipListMap<DdllKey, Link> allLinks = new ConcurrentSkipListMap<DdllKey, Link>();
        for (SGNode n : this.keyHash.values()) {
            for (Link link : n.getAllLinks(insertedOnly)) {
                allLinks.put(link.key, link);
            }
        }
        return allLinks;
    }

    public boolean addKey(Comparable<?> rawkey) throws IOException, UnavailableException {
        return this.addKey(null, rawkey);
    }

    public synchronized boolean addKey(E introducer, Comparable<?> rawkey) throws UnavailableException, IOException {
        if (this.myLocator.equals(introducer)) {
            introducer = null;
        }
        this.rtLockW();
        if (this.keyHash.containsKey(rawkey)) {
            this.rtUnlockW();
            logger.debug("addKey: already registered: {}", rawkey);
            return false;
        }
        SGNode<E> n = new SGNode<E>(this, this.mv, rawkey);
        this.keyHash.put(rawkey, n);
        this.rtUnlockW();
        try {
            boolean rc = n.addKey(introducer);
            if (!rc) {
                logger.error("addKey failed!");
                this.rtLockW();
                this.keyHash.remove(rawkey);
                this.rtUnlockW();
                return false;
            }
            return rc;
        }
        catch (UnavailableException e) {
            this.rtLockW();
            this.keyHash.remove(rawkey);
            this.rtUnlockW();
            throw e;
        }
        catch (IOException e) {
            this.rtLockW();
            this.keyHash.remove(rawkey);
            this.rtUnlockW();
            throw e;
        }
    }

    public boolean removeKey(Comparable<?> rawkey) throws IOException {
        logger.debug("removeKey key={}\n{}", rawkey, (Object)this);
        SGNode snode = (SGNode)this.keyHash.get(rawkey);
        if (snode == null) {
            return false;
        }
        boolean rc = snode.removeKey();
        if (rc) {
            this.rtLockW();
            this.keyHash.remove(rawkey);
            this.rtUnlockW();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Link[] getLocalLinks() {
        ArrayList<Link> list = new ArrayList<Link>();
        this.rtLockR();
        try {
            for (SGNode snode : this.keyHash.values()) {
                Link link = snode.getMyLinkAtLevel0();
                if (link == null) continue;
                list.add(link);
            }
        }
        finally {
            this.rtUnlockR();
        }
        Link[] links = list.toArray(new Link[list.size()]);
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public BestLink findClosestLocal(DdllKey key, boolean accurate) throws UnavailableException {
        logger.debug("findClosestLocal({}) is called at node {}", (Object)key, this.myLocator);
        logger.debug(this.toString());
        BestLink best = null;
        this.rtLockR();
        try {
            for (SGNode snode : this.keyHash.values()) {
                BestLink b = snode.findClosestLocal(key, accurate);
                logger.debug("{} says b = {} for {}", new Object[]{snode.rawkey, b, key});
                if (b == null) continue;
                if (b.isImmedPred) {
                    best = b;
                    break;
                }
                if (best == null) {
                    best = b;
                    continue;
                }
                if (!Node.isOrdered(best.link.key, b.link.key, key)) continue;
                best = b;
            }
        }
        finally {
            this.rtUnlockR();
        }
        logger.debug("findClosestLocal({}) returns {}", (Object)key, best);
        if (best == null) {
            throw new UnavailableException(this.myLocator + " has no key");
        }
        return best;
    }

    private Link findLeftLink(DdllKey key) throws UnavailableException {
        logger.debug("findLeftLink({}) is called at node {}", (Object)key, this.myLocator);
        logger.debug(this.toString());
        this.rtLockR();
        NavigableMap<DdllKey, Link> allLinks = this.getAllLinks(false);
        this.rtUnlockR();
        Map.Entry<DdllKey, Link> ent = allLinks.floorEntry(key);
        if (ent == null && (ent = allLinks.lastEntry()) == null) {
            throw new UnavailableException(this.myLocator + " has no key");
        }
        Link left = ent.getValue();
        return left;
    }

    @Override
    public SGNodeInfo getSGNodeInfo(Comparable<?> target, int level, MembershipVector mv, int nTraversed) throws NoSuchKeyException {
        SGNode snode = (SGNode)this.keyHash.get(target);
        if (snode == null) {
            throw new NoSuchKeyException(target + ", " + this.keyHash);
        }
        return snode.getSGNodeInfo(level, mv, nTraversed);
    }

    @Deprecated
    public Node.InsertPoint findOld(E introducer, DdllKey key, boolean accurate) throws UnavailableException, IOException {
        while (true) {
            BestLink bestLink = null;
            if (introducer == null) {
                bestLink = this.findClosestLocal(key, accurate);
            } else {
                SkipGraphIf stub = (SkipGraphIf)this.getStub(introducer);
                try {
                    logger.debug("find: trying to call findClosestLocal({}) at node {}", (Object)key, introducer);
                    bestLink = stub.findClosestLocal(key, accurate);
                }
                catch (UnavailableException e) {
                    throw e;
                }
                catch (RPCException e) {
                    logger.debug("", (Throwable)e);
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(e.getCause());
                }
            }
            logger.debug("find: got {}", (Object)bestLink);
            if (bestLink.isImmedPred) {
                logger.debug("find: returns {}", (Object)bestLink.link);
                return new Node.InsertPoint(bestLink.link, bestLink.rightLink);
            }
            try {
                return this.findOld(bestLink.link.addr, key, accurate);
            }
            catch (UnavailableException e) {
                logger.debug("find: got {}, retry in 1000msec", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (IOException e) {
                logger.debug("find: got {}", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public Node.InsertPoint find(E introducer, DdllKey key, boolean accurate) throws UnavailableException, IOException {
        NavigableMap<DdllKey, Link> links;
        if (introducer == null) {
            this.rtLockR();
            links = this.getAllLinks(true);
            this.rtUnlockR();
            if (links.size() == 0) {
                throw new UnavailableException("no key is available at local node");
            }
        } else {
            Object[] remoteLinks;
            SkipGraphIf stub = (SkipGraphIf)this.getStub(introducer);
            try {
                remoteLinks = stub.getLocalLinks();
            }
            catch (RPCException e) {
                logger.debug("", (Throwable)e);
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            if (remoteLinks.length == 0) {
                throw new UnavailableException("no key is available at remote node: " + introducer);
            }
            logger.debug("find: remoteLinks = {}", (Object)Arrays.toString(remoteLinks));
            links = new ConcurrentSkipListMap<DdllKey, Link>();
            links.put(((Link)remoteLinks[0]).key, (Link)remoteLinks[0]);
        }
        Range<DdllKey> range = new Range<DdllKey>(key, true, key, true);
        TransOptions opts = new TransOptions((long)FIND_INSERT_POINT_TIMEOUT, TransOptions.ResponseType.DIRECT);
        RQReturn<E> rqRet = this.rqStartKeyRange(Collections.singleton(range), QUERY_INSERT_POINT_SPECIAL, RQ_RETRANS_PERIOD, opts, links);
        try {
            Collection<RemoteValue<?>> col = rqRet.get(FIND_INSERT_POINT_TIMEOUT);
            logger.debug("find: col = {}", col);
        }
        catch (InterruptedException e) {
            throw new IOException("range query timeout");
        }
        for (DdllKeyRange kr : rqRet.rvals.values()) {
            if (((RemoteValue)kr.aux).getOption() == null) continue;
            Node.InsertPoint insp = (Node.InsertPoint)((RemoteValue)kr.aux).getOption();
            logger.debug("find: insert point = {}, {}", (Object)insp, (Object)kr);
            return insp;
        }
        throw new TemporaryIOException("could not find insert point");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustHeight(int level) {
        logger.debug("adjustHeight to {}", (Object)level);
        logger.debug(this.toString());
        this.rtLockW();
        try {
            ArrayList<Node> list = new ArrayList<Node>();
            for (SGNode snode : this.keyHash.values()) {
                if (snode.sgmode != SGNode.SGMode.INSERTED || snode.table.size() > level) continue;
                Node n = snode.createDdllNode(level);
                SGNode.Tile t = new SGNode.Tile(n, LvState.INSERTED);
                snode.table.add(level, t);
                list.add(n);
            }
            Node.initializeConnectedNodes(list);
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("****EX****");
            logger.error("", (Throwable)e);
            logger.debug(this.toString());
            System.exit(1);
        }
        finally {
            this.rtUnlockW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        int h = 0;
        this.rtLockR();
        try {
            for (SGNode snode : this.keyHash.values()) {
                int l = snode.getInsertedHeight();
                h = Math.max(h, l);
            }
        }
        finally {
            this.rtUnlockR();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteValue<?>> forwardQuery(Collection<? extends Range<?>> ranges, Object query) {
        logger.trace("ENTRY:");
        try {
            ArrayList l = new ArrayList();
            for (Range<?> r : ranges) {
                l.addAll(this.forwardQuery0(r, query));
            }
            ArrayList<RemoteValue<?>> arrayList = l;
            return arrayList;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    private List<RemoteValue<?>> forwardQuery0(Range<?> range, Object query) {
        logger.trace("ENTRY:");
        DdllKey fromKey = new DdllKey((Comparable<?>)range.from, UniqId.MINUS_INFINITY);
        DdllKey toKey = new DdllKey((Comparable<?>)range.to, UniqId.PLUS_INFINITY);
        ArrayList rset = new ArrayList();
        QueryId qid = new QueryId(this.peerId, this.rand.nextLong());
        LinkedList<Link> trace = new LinkedList<Link>();
        boolean getStartNode = true;
        Link n = null;
        while (true) {
            ExecQueryReturn eqr;
            if (getStartNode) {
                try {
                    Node.InsertPoint links = this.find(null, fromKey, true);
                    n = links.left;
                }
                catch (UnavailableException e) {
                    logger.error("", (Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                    return null;
                }
                getStartNode = false;
            }
            logger.debug("forwardQuery: query to {}", n);
            SkipGraphIf stub = (SkipGraphIf)this.getStub(n.addr);
            boolean doAction = range.contains(n.key.getPrimaryKey());
            try {
                eqr = stub.invokeExecQuery(n.key.getPrimaryKey(), null, qid, doAction, query);
            }
            catch (Throwable e) {
                Throwable cause;
                assert (e instanceof NoSuchKeyException || e instanceof RPCException);
                Throwable throwable = cause = e instanceof RPCException ? e.getCause() : e;
                if (!(cause instanceof NoSuchKeyException) && !(cause instanceof InterruptedIOException)) {
                    logger.error("forwardQueryLeft: got {} when calling invokeExecQuery() on {}", (Object)cause, (Object)n);
                    break;
                }
                logger.debug("", cause);
                if (trace.size() == 0) {
                    logger.debug("forwardQuery: start over");
                    getStartNode = true;
                    continue;
                }
                n = (Link)trace.removeLast();
                logger.debug("forwardQuery: retry from {}", (Object)n);
                continue;
            }
            if (doAction && eqr.key != null) {
                rset.add(eqr.key);
            }
            if (keyComp.isOrdered(n.key, toKey, eqr.right.key) && toKey.compareTo(eqr.right.key) != 0) {
                logger.debug("forwardQuery: reached to the right end {}", (Object)eqr.right);
                break;
            }
            trace.addLast(n);
            n = eqr.right;
            if (trace.size() > RQ_NRECENT) {
                trace.removeFirst();
            }
            logger.debug("trace= {}", trace);
        }
        return rset;
    }

    public List<RemoteValue<?>> forwardQuery(boolean isPlusDir, Range<?> range, int maxNum, Object query) {
        logger.trace("ENTRY:");
        logger.debug("isPlusdir:{}, range:{}, num:{}", new Object[]{isPlusDir, range, maxNum});
        try {
            if (!isPlusDir) {
                List<RemoteValue<?>> list = this.forwardQueryLeft(range, maxNum, query, false);
                return list;
            }
            throw new UnsupportedOperationException("upper is not supported");
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    private List<RemoteValue<?>> forwardQueryLeft(Range<?> range, int num, Object query, boolean wrapAround) {
        Object rawFromKey = range.to;
        DdllKey fromKey = range.toInclusive ? new DdllKey((Comparable<?>)rawFromKey, UniqId.PLUS_INFINITY) : new DdllKey((Comparable<?>)rawFromKey, UniqId.MINUS_INFINITY);
        Object rawToKey = range.from;
        DdllKey toKey = range.fromInclusive ? new DdllKey((Comparable<?>)rawToKey, UniqId.MINUS_INFINITY) : new DdllKey((Comparable<?>)rawToKey, UniqId.PLUS_INFINITY);
        ArrayList rset = new ArrayList();
        QueryId qid = new QueryId(this.peerId, this.rand.nextLong());
        LinkedList<Link> trace = new LinkedList<Link>();
        boolean getStartNode = true;
        Link n = null;
        Link nRight = null;
        while (true) {
            ExecQueryReturn eqr;
            if (getStartNode) {
                try {
                    Node.InsertPoint links = this.find(null, fromKey, true);
                    n = links.left;
                    nRight = links.right;
                }
                catch (UnavailableException e) {
                    logger.error("", (Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                    return null;
                }
                getStartNode = false;
            }
            if (!new Range<DdllKey>(toKey, fromKey).contains(n.key)) {
                logger.debug("forwardQueryLeft: finish (reached end of range)");
                break;
            }
            if (!wrapAround && keyComp.compare((Comparable<?>)rawFromKey, n.key.getPrimaryKey()) < 0) {
                logger.debug("forwardQueryLeft: finish (no node is smaller than rawFromKey)");
                break;
            }
            logger.debug("forwardQueryLeft: query to " + n);
            SkipGraphIf stub = (SkipGraphIf)this.getStub(n.addr);
            boolean doAction = true;
            try {
                eqr = stub.invokeExecQuery(n.key.getPrimaryKey(), nRight, qid, doAction, query);
            }
            catch (RightNodeMismatch e) {
                logger.debug("", (Throwable)e);
                if (keyComp.isOrdered(n.key, e.curRight.key, nRight.key)) {
                    n = e.curRight;
                    logger.debug("forwardQueryLeft: right node mismatch. restart from {}", (Object)n);
                    continue;
                }
                nRight = e.curRight;
                logger.debug("forwardQueryLeft: right node mismatch. continue from {}", (Object)n);
                continue;
            }
            catch (Throwable e) {
                Throwable cause;
                assert (e instanceof UnavailableException || e instanceof RPCException);
                Throwable throwable = cause = e instanceof RPCException ? e.getCause() : e;
                if (!(cause instanceof UnavailableException) && !(cause instanceof InterruptedIOException)) {
                    logger.error("forwardQueryLeft: got {} when calling invokeExecQuery() on ", (Object)cause, (Object)n);
                    break;
                }
                logger.debug("", cause);
                if (trace.size() == 0) {
                    logger.debug("forwardQueryLeft: start over");
                    getStartNode = true;
                    continue;
                }
                Link next = (Link)trace.removeLast();
                logger.debug("forwardQueryLeft: retry from {}", (Object)next);
                NodeManagerIf stub2 = (NodeManagerIf)this.manager.getStub(next.addr);
                try {
                    stub2.startFix(next.key, n, false);
                }
                catch (Exception e2) {
                    logger.info("", (Throwable)e2);
                }
                try {
                    Thread.sleep(Node.GETSTAT_OP_TIMEOUT + 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = next;
                nRight = null;
                continue;
            }
            if (doAction && eqr.key != null) {
                rset.add(eqr.key);
            }
            if (rset.size() >= num) {
                logger.debug("forwardQueryLeft: got enough");
                break;
            }
            if (Node.isOrdered(eqr.left.key, fromKey, n.key)) {
                logger.debug("forwardQueryLeft: circulated");
                break;
            }
            if (n.key.equals(eqr.left.key) && n.key.equals(eqr.right.key)) {
                logger.debug("forwardQueryLeft: just single node exists");
                break;
            }
            if (n.equals(eqr.left)) continue;
            trace.addLast(n);
            nRight = n;
            n = eqr.left;
            if (trace.size() > RQ_NRECENT) {
                trace.removeFirst();
            }
            logger.debug("trace= {}", trace);
        }
        return rset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecQueryReturn invokeExecQuery(Comparable<?> rawkey, Link curRight, QueryId qid, boolean doAction, Object query) throws NoSuchKeyException, RightNodeMismatch {
        SGNode snode;
        logger.trace("ENTRY:");
        logger.debug("invokeExecQuery: rawkey={}, curRight={}, qid={}, doAction={}", new Object[]{rawkey, curRight, qid, doAction});
        ExecQueryReturn eqr = new ExecQueryReturn();
        this.rtLockR();
        try {
            snode = (SGNode)this.keyHash.get(rawkey);
            if (snode == null) {
                throw new NoSuchKeyException(rawkey + ", " + this.keyHash);
            }
            Node node = snode.table.get((int)0).node;
            node.lock();
            if (node.getMode() == Node.Mode.GRACE || node.getMode() == Node.Mode.OUT) {
                node.unlock();
                throw new NoSuchKeyException(rawkey + " has been deleted");
            }
            eqr.right = node.getRight();
            eqr.left = node.getLeft();
            node.unlock();
            if (curRight != null && !curRight.equals(eqr.right)) {
                throw new RightNodeMismatch(eqr.right);
            }
            if (snode.sgmode == SGNode.SGMode.DELETING) {
                logger.debug("invokeExecQuery: ignore deleting node {}", (Object)snode);
                ExecQueryReturn execQueryReturn = eqr;
                return execQueryReturn;
            }
            if (!doAction) {
                ExecQueryReturn execQueryReturn = eqr;
                return execQueryReturn;
            }
        }
        finally {
            this.rtUnlockR();
        }
        boolean firsttime = false;
        Set<QueryId> set = snode.queryHistory;
        synchronized (set) {
            if (!snode.queryHistory.contains(qid)) {
                qid.timestamp = System.currentTimeMillis();
                snode.queryHistory.add(qid);
                firsttime = true;
            }
        }
        if (firsttime) {
            try {
                RemoteValue<?> l = this.execQuery(rawkey, query);
                eqr.key = l;
            }
            catch (Throwable e) {
                RemoteValue rval = new RemoteValue((Endpoint)this.peerId, e);
                eqr.key = rval;
            }
        }
        logger.debug("invokeExecQuery returns {}", (Object)eqr);
        return eqr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteValue<?> execQuery(Comparable<?> key, Object query) {
        logger.trace("ENTRY:");
        try {
            logger.debug("execQuery: key={}, query={}", key, query);
            if (this.execQueryCallback == null) {
                RemoteValue remoteValue = new RemoteValue((Endpoint)this.peerId, key);
                return remoteValue;
            }
            RemoteValue<?> remoteValue = this.execQueryCallback.sgExecQuery(key, query);
            return remoteValue;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    public FutureQueue<?> scalableRangeQuery(Collection<? extends Range<?>> ranges, Object query, TransOptions opts) {
        if (ranges.size() == 0) {
            return FutureQueue.emptyQueue();
        }
        RQReturn<E> rqRet = this.rqStartRawRange(ranges, query, RQ_RETRANS_PERIOD, opts, null);
        return rqRet != null ? rqRet.fq : null;
    }

    private RQReturn<E> rqStartRawRange(Collection<? extends Range<?>> ranges, Object query, int retransPeriod, TransOptions opts, NavigableMap<DdllKey, Link> allLinks) {
        ArrayList<Range<DdllKey>> subRanges = new ArrayList<Range<DdllKey>>();
        for (Range<?> range : ranges) {
            Range<DdllKey> keyRange = new Range<DdllKey>(new DdllKey((Comparable<?>)range.from, range.fromInclusive ? UniqId.MINUS_INFINITY : UniqId.PLUS_INFINITY), false, new DdllKey((Comparable<?>)range.to, range.toInclusive ? UniqId.PLUS_INFINITY : UniqId.MINUS_INFINITY), false);
            subRanges.add(keyRange);
        }
        return this.rqStartKeyRange(subRanges, query, retransPeriod, opts, allLinks);
    }

    private RQReturn<E> rqStartKeyRange(Collection<Range<DdllKey>> ranges, Object query, int retransPeriod, TransOptions opts, NavigableMap<DdllKey, Link> allLinks) {
        QueryId qid = new QueryId(this.peerId, this.rand.nextLong());
        RQMessage<E> msg = RQMessage.newRQMessage4Root(this.sgmf, ranges, qid, query, (int)TransOptions.timeout(opts) + RQ_EXPIRATION_GRACE, opts);
        this.rqDisseminate(msg, allLinks);
        if (msg.rqRet != null) {
            msg.rqRet.scheduleTask(this.timer, retransPeriod);
        }
        return msg.rqRet;
    }

    void rqDisseminate(RQMessage<E> msg) {
        this.rqDisseminate(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rqDisseminate(RQMessage<E> msg, NavigableMap<DdllKey, Link> allLinks) {
        Object object;
        Object subsubRanges;
        String h = "rqDiss(" + this.peerId + ", " + this.toStringShort() + ")";
        logger.debug("{}: msg = {}", (Object)h, msg);
        msg.addTrace(h);
        logger.debug("{}: trace = {}", (Object)h, msg.trace);
        if (allLinks == null) {
            this.rtLockR();
            allLinks = this.getAllLinks(false);
            this.rtUnlockR();
        } else {
            msg.cachedAllLinks = allLinks;
        }
        if (allLinks.isEmpty()) {
            logger.warn("routing table is empty!: {}", (Object)this);
            return;
        }
        StrictMap<UniqId, ArrayList<Range<DdllKey>>> map = new StrictMap<UniqId, ArrayList<Range<DdllKey>>>(new HashMap());
        StrictMap idMap = new StrictMap(new HashMap());
        ArrayList rvals = new ArrayList();
        for (Range<DdllKey> subRange : msg.subRanges) {
            subsubRanges = this.rqSplit(subRange, allLinks, msg.failedLinks, rvals);
            if (subsubRanges == null) continue;
            object = subsubRanges.iterator();
            while (object.hasNext()) {
                DdllKeyRange<Link> ddllKeyRange = object.next();
                UniqId uniqId = ddllKeyRange.aux == this.FIXLEFT ? FIXPEERID : ((Link)ddllKeyRange.aux).key.getUniqId();
                ArrayList<Range<DdllKey>> list = (ArrayList<Range<DdllKey>>)map.get(uniqId);
                if (list == null) {
                    list = new ArrayList<Range<DdllKey>>();
                    map.put(uniqId, list);
                    idMap.put(uniqId, ddllKeyRange.aux);
                }
                list.add(ddllKeyRange.range);
            }
        }
        logger.debug("{}: aggregated: {}", (Object)h, map);
        if (msg.rqRet == null) {
            msg.rqRet = new RQReturn<E>(this, msg, msg.isRoot ? 0 : msg.expire, msg.isRoot);
            if (!msg.isDirectReturn && !msg.isRoot) {
                this.timer.schedule(msg.rqRet, RQ_FLUSH_PERIOD, (long)RQ_FLUSH_PERIOD);
            }
        }
        RQReturn rqRet = msg.rqRet;
        rqRet.updateHops(msg.hops);
        List<Range<DdllKey>> failedRanges = new ArrayList<Range<DdllKey>>();
        subsubRanges = rqRet;
        synchronized (subsubRanges) {
            for (Map.Entry entry : map.entrySet()) {
                UniqId uniqId = (UniqId)entry.getKey();
                if (uniqId.equals(FIXPEERID)) {
                    failedRanges.addAll((Collection)entry.getValue());
                    continue;
                }
                if (uniqId.equals(this.peerId)) continue;
                List subRanges = (List)entry.getValue();
                logger.debug("{}: forward {}, {}", new Object[]{h, uniqId, subRanges});
                RQMessage<E> m = msg.newChildInstance(subRanges, "rqDiss@" + this.peerId + " to " + uniqId);
                Link link = (Link)idMap.get(uniqId);
                rqRet.childMsgs.put(link, m);
                m.send((Link)idMap.get(uniqId));
            }
        }
        failedRanges = RangeUtils.concatAdjacentRanges(failedRanges);
        logger.debug(h + ": merged failedRanges = " + failedRanges);
        if (!msg.failedLinks.isEmpty()) {
            this.rtLockR();
            try {
                for (SGNode sgnode : this.keyHash.values()) {
                    for (Link link : msg.failedLinks) {
                        sgnode.fixLeftLinks(link, msg.failedLinks, msg, failedRanges);
                    }
                }
            }
            finally {
                this.rtUnlockR();
            }
        }
        StrictMap<SGNode, Range<DdllKey>> matched = new StrictMap<SGNode, Range<DdllKey>>(new HashMap());
        this.rtLockR();
        try {
            for (SGNode sGNode : this.keyHash.values()) {
                SGNode.Tile tile = sGNode.getTile(0);
                if (tile == null || tile.mode != LvState.INSERTED) continue;
                Link right = sGNode.getRightAtLevel0();
                for (Range range : msg.subRanges) {
                    if (!range.contains(sGNode.key)) continue;
                    DdllKey rightKey = right.key;
                    if (sGNode.key.compareTo(rightKey) > 0) {
                        rightKey = (DdllKey)range.to;
                    }
                    Range<DdllKey> range2 = new Range<DdllKey>(sGNode.key, true, rightKey, true);
                    matched.put(sGNode, range2);
                }
            }
        }
        finally {
            this.rtUnlockR();
        }
        logger.debug("{}: matched: {}", (Object)h, matched);
        for (Map.Entry entry : matched.entrySet()) {
            RemoteValue<Object> rval;
            SGNode sGNode = (SGNode)entry.getKey();
            Range range = (Range)entry.getValue();
            if (QUERY_INSERT_POINT_SPECIAL.equals(msg.query)) {
                rval = new RemoteValue(this.peerId);
                rval.setOption(new Node.InsertPoint(sGNode.getMyLinkAtLevel0(), sGNode.getRightAtLevel0()));
            } else {
                boolean bl;
                boolean bl2 = false;
                Set<QueryId> set = sGNode.queryHistory;
                synchronized (set) {
                    if (!sGNode.queryHistory.contains(msg.qid)) {
                        msg.qid.timestamp = System.currentTimeMillis();
                        sGNode.queryHistory.add(msg.qid);
                        bl = true;
                    }
                }
                if (!bl) {
                    logger.debug("{}: not firsttime", (Object)h);
                    continue;
                }
                rval = this.execQuery(sGNode.rawkey, msg.query);
                logger.debug("{}: execQuery returns: {}", (Object)h, rval);
            }
            DdllKeyRange ddllKeyRange = new DdllKeyRange(rval, range);
            rvals.add(ddllKeyRange);
        }
        object = rqRet;
        synchronized (object) {
            for (DdllKeyRange ddllKeyRange : rvals) {
                rqRet.addRemoteValue((RemoteValue)ddllKeyRange.aux, ddllKeyRange.range);
            }
        }
        if (msg.isDirectReturn && !msg.isRoot) {
            rqRet.flush();
            rqRet.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<DdllKeyRange<Link>> rqSplit(Range<DdllKey> range0, NavigableMap<DdllKey, Link> allLinks, Collection<Link> failedLinks, List<DdllKeyRange<RemoteValue<?>>> rvals) {
        String h = "rqSplit(" + this.peerId + ", " + this.toStringShort() + ")";
        if (failedLinks == null) {
            failedLinks = Collections.emptySet();
        }
        for (Link link : failedLinks) {
            if (!link.key.getUniqId().equals(new UniqId(this.peerId))) continue;
            failedLinks.remove(link);
        }
        Range<DdllKey> range = range0;
        this.rtLockR();
        try {
            for (Object node : this.keyHash.values()) {
                SGNode.Tile t = ((SGNode)node).getTile(0);
                if (t == null || t.mode != LvState.INSERTED) continue;
                Link right = ((SGNode)node).getRightAtLevel0();
                logger.debug("{}, node = {}, range = {}, right = {}", new Object[]{h, node, range, right});
                assert (right != null);
                if (range.contains(((SGNode)node).key)) continue;
                Range<DdllKey> removed = RangeUtils.removedRange(range, ((SGNode)node).key, right.key);
                if (removed == null) continue;
                RemoteValue rv = new RemoteValue(this.peerId);
                Node.InsertPoint insp = new Node.InsertPoint(((SGNode)node).getMyLinkAtLevel0(), right);
                rv.setOption(insp);
                DdllKeyRange kr = new DdllKeyRange(rv, removed);
                logger.debug("{}: dummy rval {}", (Object)h, kr);
                rvals.add(kr);
                range = RangeUtils.retainRange(range, ((SGNode)node).key, right.key);
                logger.debug("{}: retain = {}", (Object)h, range);
                if (range != null) continue;
                List<DdllKeyRange<Link>> list = null;
                return list;
            }
        }
        finally {
            this.rtUnlockR();
        }
        if (range0 != range) {
            logger.debug("{}: shrunk, {} => {}", new Object[]{h, range0, range});
        }
        ConcurrentSkipListMap<DdllKey, Link> concurrentSkipListMap = new ConcurrentSkipListMap<DdllKey, Link>((SortedMap<DdllKey, Link>)allLinks);
        for (Link l2 : failedLinks) {
            concurrentSkipListMap.put(l2.key, l2);
        }
        List<DdllKeyRange<Link>> ranges = DdllKeyRange.split(range, concurrentSkipListMap);
        DdllKeyRange<Link> l = ranges.get(ranges.size() - 1);
        DdllKey key = (DdllKey)l.range.to;
        Map.Entry<DdllKey, Link> ent = allLinks.ceilingEntry(key);
        if (ent == null) {
            ent = allLinks.firstEntry();
        }
        while (failedLinks.contains(ent.getValue())) {
            if ((ent = allLinks.higherEntry(ent.getKey())) == null) {
                ent = allLinks.firstEntry();
            }
            assert (ent != null);
        }
        ranges.add(new DdllKeyRange<Link>(ent.getValue(), null));
        logger.debug("{}: allLinks = {}", (Object)h, allLinks.values());
        logger.debug("{}: extAllLinks = {}", (Object)h, concurrentSkipListMap.values());
        logger.debug("{}: failedLinks = {}", (Object)h, failedLinks);
        logger.debug("{}: ranges = {}", (Object)h, ranges);
        ArrayList<DdllKeyRange<Link>> ranges2 = new ArrayList<DdllKeyRange<Link>>();
        ArrayList<DdllKeyRange<Link>> carryovers = new ArrayList<DdllKeyRange<Link>>();
        for (int i = 0; i < ranges.size(); ++i) {
            DdllKeyRange<Link> r = ranges.get(i);
            if (r.aux == null || failedLinks.contains(r.aux)) {
                carryovers.add(r);
                continue;
            }
            if (!carryovers.isEmpty()) {
                DdllKeyRange missingRange;
                block32: {
                    logger.debug("carryovers = {}", carryovers);
                    missingRange = null;
                    for (DdllKeyRange ddllKeyRange : carryovers) {
                        if (missingRange == null) {
                            missingRange = ddllKeyRange;
                            continue;
                        }
                        missingRange = missingRange.concatenate(ddllKeyRange, false);
                    }
                    if (((Link)r.aux).key.getUniqId().equals(new UniqId(this.peerId))) {
                        boolean bl;
                        boolean knownNodeFailure = false;
                        block12: for (DdllKeyRange ddllKeyRange : carryovers) {
                            if (ddllKeyRange.aux == null) continue;
                            for (DdllKey k : allLinks.keySet()) {
                                if (k.compareTo(((Link)ddllKeyRange.aux).key) != 0) continue;
                                knownNodeFailure = true;
                                continue block12;
                            }
                        }
                        boolean bl2 = false;
                        if (!knownNodeFailure) {
                            void var16_30;
                            Map.Entry<DdllKey, Link> entry = allLinks.lowerEntry(((Link)r.aux).key);
                            if (entry == null) {
                                Map.Entry<DdllKey, Link> entry2 = allLinks.lastEntry();
                            }
                            if (failedLinks.contains(var16_30.getValue())) {
                                bl = true;
                            }
                        }
                        logger.debug("knownNodeFailure = {}, immedLeftFailure = {}", (Object)knownNodeFailure, (Object)bl);
                        if (knownNodeFailure || bl) {
                            missingRange.aux = this.FIXLEFT;
                        } else {
                            try {
                                Link link = this.findLeftLink((DdllKey)missingRange.range.from);
                                if (failedLinks.contains(link)) {
                                    missingRange.aux = this.FIXLEFT;
                                    break block32;
                                }
                                missingRange.aux = link;
                            }
                            catch (UnavailableException unavailableException) {
                                logger.error("", (Throwable)unavailableException);
                            }
                        }
                    } else {
                        missingRange.aux = r.aux;
                    }
                }
                ranges2.add(missingRange);
                carryovers.clear();
            }
            if (i >= ranges.size() - 1) continue;
            ranges2.add(r);
        }
        logger.debug("{}: results = {}", (Object)h, ranges2);
        return ranges2;
    }

    void rqSetReturnValue(RQReturn<E> rq, PeerId sender, Collection<DdllKeyRange<RemoteValue<?>>> vals, int hops) {
        String h = "rqSetReturnValue(" + this.peerId + ", " + this.toStringShort() + ")";
        logger.debug("{}, sender = {}, rq = {}, rvals = {}, hops = {}", new Object[]{h, sender, rq, vals, hops});
        boolean rc = rq.confirmResponseFromChildNode(sender);
        if (!rc && !rq.parentMsg.isDirectReturn) {
            logger.debug("{}: {} is not contained in childMsgs of {}", new Object[]{h, sender, rq});
        }
        rq.incrementRcvCount();
        rq.updateHops(hops);
        for (DdllKeyRange<RemoteValue<?>> er : vals) {
            rq.addRemoteValue((RemoteValue)er.aux, er.range);
        }
        logger.debug("{}: rq = {}", (Object)h, rq);
    }

    void fixRoutingTables(Collection<Link> failedLinks, RQMessage<E> parentMsg, Collection<Range<DdllKey>> failedRanges) {
        String h = "fixRoutingTable@" + this.myLocator;
        logger.debug("{}: failedLinks = {}, failedRanges = {}, parentMsg = {}", new Object[]{h, failedLinks, failedRanges, parentMsg});
        if (parentMsg.rqRet == null) {
            parentMsg.rqRet = new RQReturn<E>(this, parentMsg, parentMsg.expire, false);
            parentMsg.sgmf = this.sgmf;
            logger.debug("{}: create new RQReturn: {}", (Object)h, parentMsg.rqRet);
        }
        RQMessage<E> msg = parentMsg.newChildInstance(failedRanges, "fixRT@" + this.peerId);
        msg.addFailedLinks(failedLinks);
        this.rqDisseminate(msg);
    }

    @Override
    public void requestMsgReceived(SGMessagingFramework.SGRequestMessage<E> sgMessage) {
        this.sgmf.requestMsgReceived(sgMessage);
    }

    @Override
    public void replyMsgReceived(SGMessagingFramework.SGReplyMessage<E> sgReplyMessage) {
        this.sgmf.replyMsgReceived(sgReplyMessage);
    }

    @Override
    public void ackReceived(int msgId) {
        this.sgmf.ackReceived(msgId);
    }

    @Override
    public void fixAndPropagateSingle(Comparable<?> target, Link failedLink, Collection<Link> failedLinks, DdllKey rLimit) {
        SGNode snode = (SGNode)this.keyHash.get(target);
        if (snode == null) {
            logger.debug("no such key {}", target);
            return;
        }
        snode.fixAndPropagateRight(failedLink, failedLinks, rLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getHeight(Comparable<?> key) {
        SGNode s = (SGNode)this.keyHash.get(key);
        if (s != null) {
            this.rtLockR();
            try {
                int n = s.getInsertedHeight();
                return n;
            }
            finally {
                this.rtUnlockR();
            }
        }
        return 0;
    }

    Link getLocal(Comparable<?> key) {
        return ((SGNode)this.keyHash.get(key)).getMyLinkAtLevel0();
    }

    Link[] getNeighbors(Comparable<?> key, boolean right, int level) {
        ArrayList<Link> ret = new ArrayList<Link>();
        if (key == null) {
            this.keyHash.values().forEach(snode -> {
                SGNode s = snode;
                ret.addAll(s.getAllLinks(true));
            });
        } else {
            SGNode s = (SGNode)this.keyHash.get(key);
            if (right) {
                ret.add(s.getRightLink(level));
            } else {
                ret.add(s.getLeftLink(level));
            }
        }
        return ret.toArray(new Link[0]);
    }

    public static class RightNodeMismatch
    extends Exception {
        public Link curRight;

        public RightNodeMismatch(Link curRight) {
            this.curRight = curRight;
        }

        @Override
        public String toString() {
            return "RightNodeMismatch(curRight=" + this.curRight + ")";
        }
    }

    public static class ExecQueryReturn
    implements Serializable {
        public RemoteValue<?> key;
        public Link left;
        public Link right;

        public String toString() {
            return "ExecQueryReturn[" + this.key + ", left=" + this.left + ", right=" + this.right + "]";
        }
    }

    public static class SGNodeInfo
    implements Serializable {
        final Link me;
        final Link left;
        final Link right;

        public SGNodeInfo(Link me, Link left, Link right) {
            this.me = me;
            this.left = left;
            this.right = right;
        }

        public boolean proceedRight() {
            return this.right != null;
        }

        public boolean foundInserted() {
            return this.me != null;
        }

        public String toString() {
            return "SGNodeInfo[me=" + this.me + ", l=" + this.left + ", r=" + this.right + "]";
        }
    }

    static class QueryId
    implements Serializable {
        final PeerId sourcePeer;
        final long id;
        long timestamp;

        private QueryId(PeerId sourcePeer, long id) {
            this.sourcePeer = sourcePeer;
            this.id = id;
        }

        public boolean equals(Object obj) {
            QueryId o = (QueryId)obj;
            return this.sourcePeer.equals(o.sourcePeer) && this.id == o.id;
        }

        public int hashCode() {
            return this.sourcePeer.hashCode() ^ (int)this.id;
        }

        public String toString() {
            return "qid[" + this.sourcePeer + "-" + this.id + "]";
        }
    }

    public static class BestLink
    implements Serializable {
        final Link link;
        final Link rightLink;
        final boolean isImmedPred;

        public BestLink(Link link, Link rightLink, boolean isImmedPred) {
            this.link = link;
            this.rightLink = rightLink;
            this.isImmedPred = isImmedPred;
        }

        public String toString() {
            return "BestLink(link=" + this.link + ", right=" + this.rightLink + ", " + this.isImmedPred + ")";
        }
    }

    class PurgeTask
    extends TimerTask {
        PurgeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long threshold = System.currentTimeMillis() - (long)QID_EXPIRE;
            SkipGraph.this.rtLockR();
            for (SGNode snode : SkipGraph.this.keyHash.values()) {
                Set<QueryId> set = snode.queryHistory;
                synchronized (set) {
                    Iterator<QueryId> it = snode.queryHistory.iterator();
                    while (it.hasNext()) {
                        QueryId q = it.next();
                        if (q.timestamp >= threshold) continue;
                        it.remove();
                    }
                }
            }
            SkipGraph.this.rtUnlockR();
        }
    }

    public static enum LvState {
        INSERTING,
        INSERTED;

    }
}

