/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.szk;

import org.piax.common.Endpoint;
import org.piax.gtrans.ov.ring.rq.FlexibleArray;
import org.piax.gtrans.ov.szk.ChordSharpVNode;
import org.piax.gtrans.ov.szk.FTEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerTable<E extends Endpoint> {
    private static final Logger logger = LoggerFactory.getLogger(FingerTable.class);
    public static final int B = 2;
    public static final int K = 4;
    public static final int LOCALINDEX = -1;
    final ChordSharpVNode<E> vnode;
    final FlexibleArray<FTEntry> table;
    final boolean isBackward;

    public FingerTable(ChordSharpVNode<E> vnode, boolean isBackward) {
        this.vnode = vnode;
        this.isBackward = isBackward;
        if (isBackward) {
            this.table = new FlexibleArray(0);
        } else {
            this.table = new FlexibleArray(-1);
            FTEntry local1 = vnode.getLocalFTEnetry();
            this.set(-1, local1);
        }
        FTEntry local2 = vnode.getLocalFTEnetry();
        this.set(0, local2);
    }

    public void set(int index, FTEntry ent) {
        this.table.set(index, ent);
        logger.debug("FingerTable#set index={}, ent={}", (Object)index, (Object)ent);
    }

    public int getFingerTableSize() {
        return this.table.maxIndexPlus1();
    }

    FTEntry getFTEntry(int index) {
        FTEntry ent = this.table.get(index);
        if (index == -1) {
            ent.updateLocalEntry(this.vnode);
        } else if (index == 0) {
            ent.link = this.isBackward ? this.vnode.getPredecessor() : this.vnode.getSuccessor();
        }
        return ent;
    }

    public void shrink(int index) {
        this.table.shrink(index);
    }

    public static int getFTIndex(int i, int j) {
        assert (i >= 0);
        assert (j >= 1);
        return 3 * i + (j - 1);
    }

    public static int getFTIndex(int distance) {
        if (distance == 0) {
            return -1;
        }
        int x = 0;
        int i;
        int j;
        int d;
        while (distance != (d = (j = x - 3 * (i = x / 3) + 1) * (1 << 2 * i))) {
            if (distance < d) {
                return x - 1;
            }
            ++x;
        }
        return x;
    }
}

