/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.piax.common.PeerLocator;

public abstract class InetLocator
extends PeerLocator {
    private static final long serialVersionUID = 1L;
    private static final byte[] nullAddr = new byte[]{0, 0, 0, 0, 0, 0};
    private transient InetSocketAddress addr;

    private static void xor(byte[] ip) {
        for (int i = 0; i < ip.length; ++i) {
            ip[i] = ~ip[i];
        }
    }

    public static void putAddr(ByteBuffer bbuf, InetSocketAddress addr) {
        if (addr == null) {
            bbuf.put(nullAddr);
        } else {
            byte[] ip = addr.getAddress().getAddress();
            InetLocator.xor(ip);
            bbuf.put(ip);
            bbuf.putShort((short)addr.getPort());
        }
    }

    public static InetSocketAddress getAddr(ByteBuffer bbuf) throws UnknownHostException {
        byte[] ip = new byte[4];
        InetSocketAddress addr = null;
        bbuf.get(ip);
        InetLocator.xor(ip);
        int port = bbuf.getShort() & 0xFFFF;
        if (port != 0) {
            addr = new InetSocketAddress(InetAddress.getByAddress(ip), port);
        }
        return addr;
    }

    protected InetLocator(InetSocketAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("argument should not be null");
        }
        this.addr = addr;
    }

    public String getHostName() {
        return this.addr.getHostName();
    }

    public byte[] getHostAddress() {
        return this.addr.getAddress().getAddress();
    }

    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetLocator)) {
            return false;
        }
        InetLocator _obj = (InetLocator)obj;
        if (this.getPort() != _obj.getPort()) {
            return false;
        }
        return this.addr.getAddress().equals(_obj.addr.getAddress());
    }

    public int hashCode() {
        return this.addr.getPort();
    }

    public String toString() {
        return this.addr.getAddress().getHostAddress() + ":" + this.getPort();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.addr.getAddress().getHostAddress());
        s.writeInt(this.addr.getPort());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String hostname = (String)s.readObject();
        int port = s.readInt();
        this.addr = new InetSocketAddress(hostname, port);
    }
}

