/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.piax.common.ObjectId;
import org.piax.common.PeerLocator;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.NetworkTimeoutException;

public abstract class RawChannel<E extends PeerLocator>
implements Channel<E> {
    private static final Object END_OF_MESSAGE = new Object();
    private final BlockingQueue<Object> rcvQueue = new LinkedBlockingQueue<Object>();
    protected volatile boolean isActive = true;

    @Override
    public void close() {
        try {
            this.rcvQueue.clear();
            this.rcvQueue.put(END_OF_MESSAGE);
            this.isActive = false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isActive;
    }

    @Override
    public abstract int getChannelNo();

    @Override
    public abstract E getRemote();

    @Override
    public abstract boolean isCreatorSide();

    public abstract void send(ByteBuffer var1) throws IOException;

    @Override
    public void send(Object msg) throws IOException {
        if (!(msg instanceof ByteBuffer)) {
            throw new IllegalArgumentException("msg type should be ByteBuffer");
        }
        this.send((ByteBuffer)msg);
    }

    protected void putReceiveQueue(Object msg) {
        try {
            this.rcvQueue.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Object receive() {
        try {
            return this.receive(0);
        }
        catch (NetworkTimeoutException e) {
            return null;
        }
    }

    @Override
    public Object receive(int timeout) throws NetworkTimeoutException {
        try {
            Object msg = this.rcvQueue.poll(timeout, TimeUnit.MILLISECONDS);
            if (msg == END_OF_MESSAGE) {
                return null;
            }
            if (msg == null) {
                throw new NetworkTimeoutException("ch.receive timed out");
            }
            return msg;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public TransportId getTransportId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getLocal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectId getLocalObjectId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectId getRemoteObjectId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDuplex() {
        throw new UnsupportedOperationException();
    }
}

