/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.lwtcp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.TimerTask;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.NoSuchPeerException;
import org.piax.gtrans.raw.RawChannel;
import org.piax.gtrans.raw.lwtcp.LWTcpTransport;
import org.piax.gtrans.raw.tcp.TcpLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWTcpChannel
extends RawChannel<TcpLocator>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LWTcpChannel.class);
    static int READ_BUFFER_KEEP_TIME = 100;
    final boolean isServer;
    final LWTcpTransport transport;
    final SocketChannel soc;
    final int maxReadLen;
    final SelectionKey skey;
    private volatile boolean isClosed;
    private Object writableWaitObject = new Object();
    private TimerTask timerTask = null;
    private TcpLocator remote = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LWTcpChannel(LWTcpTransport transport, SocketChannel soc, int maxReadLen, Selector sel) throws IOException {
        this.isServer = true;
        this.soc = soc;
        soc.configureBlocking(false);
        this.transport = transport;
        soc.socket().setSendBufferSize(GTransConfigValues.SOCKET_SEND_BUF_SIZE);
        soc.socket().setReceiveBufferSize(GTransConfigValues.SOCKET_RECV_BUF_SIZE);
        this.maxReadLen = maxReadLen;
        this.remote = new TcpLocator((InetSocketAddress)soc.socket().getRemoteSocketAddress());
        this.isClosed = false;
        LWTcpTransport lWTcpTransport = transport;
        synchronized (lWTcpTransport) {
            sel.wakeup();
            this.skey = soc.register(sel, 1, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LWTcpChannel(LWTcpTransport transport, SocketAddress dst, int maxReadLen, Selector sel) throws IOException {
        this.isServer = false;
        this.soc = SocketChannel.open();
        try {
            this.soc.connect(dst);
        }
        catch (SocketException e) {
            throw new NoSuchPeerException(e + ": " + dst);
        }
        this.soc.configureBlocking(false);
        this.transport = transport;
        this.soc.socket().setSendBufferSize(GTransConfigValues.SOCKET_SEND_BUF_SIZE);
        this.soc.socket().setReceiveBufferSize(GTransConfigValues.SOCKET_RECV_BUF_SIZE);
        this.maxReadLen = maxReadLen;
        this.remote = new TcpLocator((InetSocketAddress)this.soc.socket().getRemoteSocketAddress());
        this.isClosed = false;
        LWTcpTransport lWTcpTransport = transport;
        synchronized (lWTcpTransport) {
            sel.wakeup();
            this.skey = this.soc.register(sel, 1, this);
        }
    }

    @Override
    public boolean isCreatorSide() {
        return this.isServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LWTcpTransport lWTcpTransport = this.transport;
        synchronized (lWTcpTransport) {
            logger.trace("ENTRY:");
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.skey.cancel();
            super.close();
            try {
                if (this.transport.linger0Option()) {
                    this.soc.socket().setSoLinger(true, 0);
                } else {
                    this.soc.socket().shutdownOutput();
                }
                this.soc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.transport.removeChannel(this);
            this.wakeupWritable();
            logger.trace("EXIT:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupWritable() {
        Object object = this.writableWaitObject;
        synchronized (object) {
            this.writableWaitObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(ByteBuffer bbuf) throws IOException {
        bbuf.rewind();
        int n = bbuf.remaining();
        while (bbuf.remaining() > 0) {
            int r = this.soc.write(bbuf);
            if (r != 0) continue;
            Object object = this.transport;
            synchronized (object) {
                this.skey.selector().wakeup();
                SelectionKey selectionKey = this.skey;
                synchronized (selectionKey) {
                    this.skey.interestOps(this.skey.interestOps() | 4);
                }
            }
            object = this.writableWaitObject;
            synchronized (object) {
                if ((this.skey.interestOps() & 4) != 0) {
                    try {
                        this.writableWaitObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        logger.debug("send: wrote bytes {}", (Object)n);
    }

    public static void freeDirectBuffer(ByteBuffer buffer) {
        try {
            Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
            Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            cleanMethod.setAccessible(true);
            cleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (Throwable e) {
            logger.error("Freeing direct buffer:e " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ByteBuffer readBuf;
        block13: {
            logger.trace("ENTRY:");
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            readBuf = ByteBuffer.allocateDirect(this.maxReadLen);
            try {
                int n;
                while ((n = this.soc.read(readBuf)) > 0) {
                    logger.debug("run: received body bytes {}", (Object)n);
                    ByteBuffer bb = ByteBuffer.allocate(n);
                    readBuf.flip();
                    bb.put(readBuf);
                    bb.flip();
                    this.putReceiveQueue(bb);
                    this.transport.onReceive(this);
                    readBuf.clear();
                }
                if (n == -1) {
                    if (!this.isClosed) {
                        this.transport.onClosed(this);
                    }
                    break block13;
                }
                LWTcpTransport lWTcpTransport = this.transport;
                synchronized (lWTcpTransport) {
                    this.skey.selector().wakeup();
                    SelectionKey selectionKey = this.skey;
                    synchronized (selectionKey) {
                        if (this.skey.isValid()) {
                            this.skey.interestOps(this.skey.interestOps() | 1);
                        }
                    }
                }
            }
            catch (IOException e) {
                if (this.isClosed) break block13;
                this.transport.onFailure(this, e);
            }
        }
        LWTcpChannel.freeDirectBuffer(readBuf);
        logger.trace("EXIT:");
    }

    @Override
    public TcpLocator getRemote() {
        return this.remote;
    }

    @Override
    public int getChannelNo() {
        return this.isServer ? this.soc.socket().getPort() : this.soc.socket().getLocalPort();
    }
}

