/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.NoSuchPeerException;
import org.piax.gtrans.raw.RawChannel;
import org.piax.gtrans.raw.tcp.TcpLocator;
import org.piax.gtrans.raw.tcp.TcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpChannel
extends RawChannel<TcpLocator>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TcpChannel.class);
    final boolean isServer;
    final TcpTransport transport;
    final Socket soc;
    final InputStream in;
    final OutputStream out;
    final int maxReadLen;
    final byte[] readBuf;
    private volatile boolean isClosed;
    private volatile long lastActivated;
    private TcpLocator remote = null;

    TcpChannel(TcpTransport transport, Socket soc, int maxReadLen) throws IOException {
        this.isServer = true;
        this.soc = soc;
        this.transport = transport;
        soc.setSendBufferSize(GTransConfigValues.SOCKET_SEND_BUF_SIZE);
        soc.setReceiveBufferSize(GTransConfigValues.SOCKET_RECV_BUF_SIZE);
        this.in = soc.getInputStream();
        this.out = soc.getOutputStream();
        this.maxReadLen = maxReadLen;
        this.readBuf = new byte[maxReadLen];
        this.isClosed = false;
        this.lastActivated = System.currentTimeMillis();
    }

    TcpChannel(TcpTransport transport, SocketAddress dst, int maxReadLen, int timeout) throws IOException {
        this.isServer = false;
        this.soc = new Socket();
        try {
            this.soc.connect(dst, timeout);
        }
        catch (SocketException e) {
            throw new NoSuchPeerException(e + ": " + dst);
        }
        this.transport = transport;
        this.soc.setSendBufferSize(GTransConfigValues.SOCKET_SEND_BUF_SIZE);
        this.soc.setReceiveBufferSize(GTransConfigValues.SOCKET_RECV_BUF_SIZE);
        this.in = this.soc.getInputStream();
        this.out = this.soc.getOutputStream();
        this.maxReadLen = maxReadLen;
        this.readBuf = new byte[maxReadLen];
        this.isClosed = false;
        this.lastActivated = System.currentTimeMillis();
    }

    @Override
    public boolean isCreatorSide() {
        return this.isServer;
    }

    private long getIdleTime() {
        long t = System.currentTimeMillis() - this.lastActivated;
        return t;
    }

    @Override
    public synchronized void close() {
        logger.trace("ENTRY:");
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        super.close();
        try {
            this.soc.shutdownOutput();
            this.soc.close();
        }
        catch (IOException ignore) {
            logger.info("", (Throwable)ignore);
        }
        this.transport.removeChannel(this);
        logger.trace("EXIT:");
    }

    synchronized boolean checkActiveAndTouch() {
        if (this.isClosed) {
            return false;
        }
        this.lastActivated = System.currentTimeMillis();
        return true;
    }

    synchronized boolean closeIfPurged(long purgeTime) {
        if (this.isClosed) {
            return true;
        }
        if (this.getIdleTime() < purgeTime) {
            return false;
        }
        this.close();
        return true;
    }

    @Override
    public synchronized void send(ByteBuffer bbuf) throws IOException {
        this.out.write(bbuf.array(), 0, bbuf.remaining());
        this.out.flush();
        logger.debug("send: wrote bytes {}", (Object)bbuf.remaining());
        this.lastActivated = System.currentTimeMillis();
    }

    @Override
    public void run() {
        block5: {
            logger.trace("ENTRY:");
            try {
                while (true) {
                    int n;
                    if ((n = this.in.read(this.readBuf)) == -1) {
                        if (!this.isClosed) {
                            this.transport.onClosed(this);
                        }
                        break;
                    }
                    logger.debug("run: received body bytes {}", (Object)n);
                    this.lastActivated = System.currentTimeMillis();
                    ByteBuffer bb = ByteBuffer.wrap(Arrays.copyOf(this.readBuf, n));
                    this.putReceiveQueue(bb);
                    this.transport.onReceive(this);
                }
            }
            catch (IOException e) {
                if (this.isClosed) break block5;
                this.transport.onFailure(this, e);
            }
        }
        logger.trace("EXIT:");
    }

    @Override
    public TcpLocator getRemote() {
        if (this.remote == null) {
            this.remote = new TcpLocator((InetSocketAddress)this.soc.getRemoteSocketAddress());
        }
        return this.remote;
    }

    @Override
    public int getChannelNo() {
        return this.isServer ? this.soc.getPort() : this.soc.getLocalPort();
    }
}

