/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.tsd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.gtrans.tsd.ServiceInfo;
import org.piax.gtrans.tsd.TSD;
import org.piax.util.ByteUtil;
import org.piax.util.SerializingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastTSD<T>
extends TSD<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MulticastTSD.class);
    static String THREAD_NAME_PREFIX = "mTSD";
    static final AtomicInteger thNum = new AtomicInteger(1);
    public static int PSDP_PORT = 12369;
    public static String PSDP_GROUP = "239.0.0.45";
    private static MulticastTSD instance = null;
    private static int refCounter = 0;
    protected final MulticastSocket socket;
    protected final InetAddress group = InetAddress.getByName(PSDP_GROUP);
    protected boolean isTerminated;

    public static synchronized <T> MulticastTSD<T> genTSD() throws IOException {
        if (instance != null) {
            ++refCounter;
            return instance;
        }
        instance = new MulticastTSD<T>();
        new Thread((Runnable)instance, THREAD_NAME_PREFIX + thNum.getAndIncrement()).start();
        ++refCounter;
        return instance;
    }

    private MulticastTSD() throws IOException {
        this.socket = new MulticastSocket(PSDP_PORT);
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
        this.isTerminated = false;
    }

    @Override
    public synchronized void fin() {
        if (this.isTerminated) {
            return;
        }
        if (--refCounter > 0) {
            return;
        }
        this.isTerminated = true;
        refCounter = 0;
        instance = null;
        try {
            this.socket.leaveGroup(this.group);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
        this.socket.close();
    }

    @Override
    public void run() {
        byte[] in = new byte[1400];
        DatagramPacket inPac = new DatagramPacket(in, in.length);
        while (!this.isTerminated) {
            try {
                this.socket.receive(inPac);
                int len = inPac.getLength();
                ServiceInfo info = (ServiceInfo)SerializingUtil.deserialize(in, 0, len);
                this.found(info);
            }
            catch (IOException e) {
                if (this.isTerminated) break;
                logger.warn("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error("", (Throwable)e);
            }
            catch (ClassCastException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    @Override
    protected void advertise(ServiceInfo<T> info) throws IOException {
        logger.debug("advertise info {}", info);
        byte[] data = SerializingUtil.serialize(info);
        DatagramPacket outPac = new DatagramPacket(data, data.length, this.group, PSDP_PORT);
        this.socket.send(outPac);
        if (logger.isDebugEnabled()) {
            logger.debug("advertise bytes {}", (Object)ByteUtil.bytes2Hex(data));
        }
    }
}

