/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.tsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.Discoverable;
import org.piax.gtrans.DiscoveryListener;
import org.piax.gtrans.PeerInfo;
import org.piax.gtrans.tsd.BroadcastTSD;
import org.piax.gtrans.tsd.MulticastTSD;
import org.piax.gtrans.tsd.TSD;
import org.piax.gtrans.tsd.TSDListener;

public class TSDDiscoverable<E extends Endpoint>
implements Discoverable<E>,
TSDListener {
    public static long DEFAULT_EXPIRATION_TIME = 30000L;
    final PeerId peerId;
    private final TSD<PeerInfo<E>> tsd;
    final TransportId transId;
    protected final Set<DiscoveryListener<E>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final ConcurrentLinkedQueue<InfoBox<PeerInfo<E>>> availableInfoQueue = new ConcurrentLinkedQueue();
    private long expireTime = DEFAULT_EXPIRATION_TIME;

    public TSDDiscoverable(PeerId peerId, Type type, TransportId transId) throws IOException {
        this.peerId = peerId;
        switch (type) {
            case MULTICAST: {
                this.tsd = MulticastTSD.genTSD();
                break;
            }
            case BROADCAST: {
                this.tsd = BroadcastTSD.genTSD();
                break;
            }
            default: {
                this.tsd = null;
            }
        }
        this.transId = transId;
        this.tsd.setDiscoveryListener(peerId, transId, this);
    }

    @Override
    public void fin() {
        this.tsd.setDiscoveryListener(this.peerId, this.transId, null);
        this.tsd.unregisterAllServices(this.peerId, this.transId);
        this.tsd.fin();
        this.availableInfoQueue.clear();
        this.listeners.clear();
    }

    @Override
    public void setExpireTime(long period) {
        this.expireTime = period;
    }

    @Override
    public void register(PeerInfo<E> info) {
        this.tsd.registerService(this.peerId, this.transId, info);
    }

    @Override
    public void unregister(PeerInfo<E> info) {
        this.tsd.unregisterService(this.peerId, this.transId, info);
    }

    @Override
    public List<PeerInfo<E>> getAvailablePeerInfos() {
        ArrayList avail = new ArrayList();
        for (InfoBox<PeerInfo<E>> infoBox : this.availableInfoQueue) {
            avail.add(infoBox.serv);
        }
        return avail;
    }

    @Override
    public boolean addDiscoveryListener(DiscoveryListener<E> listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeDiscoveryListener(DiscoveryListener<E> listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void scheduleDiscovery(long delay, long period) {
        this.tsd.scheduleDiscovery(this.peerId, this.transId, delay, period);
    }

    @Override
    public void cancelDiscovery() {
        this.tsd.cancelDiscovery(this.peerId, this.transId);
    }

    @Override
    public void onDiscovered(Object info) {
        InfoBox<PeerInfo> infoBox = new InfoBox<PeerInfo>((PeerInfo)info);
        boolean isNew = !this.availableInfoQueue.remove(infoBox);
        this.availableInfoQueue.offer(infoBox);
        for (DiscoveryListener<E> listener : this.listeners) {
            listener.onDiscovered((PeerInfo)info, isNew);
        }
    }

    @Override
    public void onFadeoutCheck() {
        long past = System.currentTimeMillis() - this.expireTime;
        InfoBox<PeerInfo<E>> infoBox = this.availableInfoQueue.peek();
        if (infoBox == null) {
            return;
        }
        if (past < infoBox.lastObserved) {
            return;
        }
        this.availableInfoQueue.poll();
        for (DiscoveryListener<E> listener : this.listeners) {
            listener.onFadeout((PeerInfo)infoBox.serv);
        }
    }

    public static enum Type {
        MULTICAST,
        BROADCAST;

    }

    static class InfoBox<T> {
        final T serv;
        final long lastObserved;

        InfoBox(T info) {
            this.serv = info;
            this.lastObserved = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.serv == null ? 0 : this.serv.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof InfoBox)) {
                return false;
            }
            InfoBox _obj = (InfoBox)obj;
            return this.serv == null ? _obj.serv == null : this.serv.equals(_obj.serv);
        }
    }
}

