/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.util;

import java.io.IOException;
import org.piax.common.Endpoint;
import org.piax.common.TransportId;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.util.ChannelAddOnTransport;
import org.piax.util.MersenneTwister;

public class FailureSimulationChannelTransport<E extends Endpoint>
extends ChannelAddOnTransport<E> {
    private final String DEFAULT_ERROR_RATE = "30";
    private boolean suspend_transport = false;
    private boolean upset_transport = false;
    private int error_rate = Integer.parseInt("30");
    private float probability = (float)this.error_rate / 100.0f;
    MersenneTwister mt = new MersenneTwister();

    public FailureSimulationChannelTransport(Transport<? super E> lowerTrans) throws IdConflictException {
        this(new TransportId("failure"), lowerTrans);
    }

    public FailureSimulationChannelTransport(TransportId transId, Transport<? super E> lowerTrans) throws IdConflictException {
        super(transId, lowerTrans);
    }

    public boolean toggleTransport() {
        this.suspend_transport = !this.suspend_transport;
        return this.suspend_transport;
    }

    public boolean suspendTransport() {
        this.suspend_transport = true;
        return this.suspend_transport;
    }

    public boolean resumeTransport() {
        this.suspend_transport = false;
        return this.suspend_transport;
    }

    public boolean upsetTransport() {
        this.upset_transport = true;
        return this.upset_transport;
    }

    public boolean repairTransport() {
        this.upset_transport = false;
        return this.upset_transport;
    }

    public void setErrorRate(int rate) {
        this.error_rate = rate;
        this.probability = (float)this.error_rate / 100.0f;
    }

    public int getErrorRate() {
        return this.error_rate;
    }

    public boolean isSuspended() {
        return this.suspend_transport;
    }

    public boolean isUpset() {
        return this.upset_transport;
    }

    @Override
    protected NestedMessage _preReceive(ReceivedMessage rmsg) {
        if (this.suspend_transport) {
            return null;
        }
        if (this.upset_transport) {
            double d = this.mt.nextDouble();
            if (d >= (double)this.probability) {
                return super._preReceive(rmsg);
            }
            return null;
        }
        return super._preReceive(rmsg);
    }

    @Override
    protected void lowerSend(E dst, NestedMessage nmsg) throws ProtocolUnsupportedException, IOException {
        super.lowerSend(dst, nmsg);
    }
}

