/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.nio.ByteBuffer;

public class ByteBufferUtil {
    static final int DEFAULT_HEADER_MARGIN = 256;
    static final int DEFAULT_ENHANCE_SIZE = 256;

    public static void clear(ByteBuffer b) {
        b.reset();
        b.limit(b.capacity());
    }

    public static void flip(ByteBuffer b) {
        b.limit(b.position());
        b.reset();
    }

    public static void rewind(ByteBuffer b) {
        b.reset();
    }

    public static void flop(ByteBuffer b) {
        b.position(b.limit());
        b.limit(b.capacity());
    }

    public static void mark(ByteBuffer b) {
        b.mark();
    }

    public static void reset(int offset, ByteBuffer b) {
        b.position(offset);
        b.mark();
    }

    public static ByteBuffer newByteBuffer(int margin, int capacity) {
        ByteBuffer b = ByteBuffer.wrap(new byte[margin + capacity]);
        b.position(margin);
        b.mark();
        return b;
    }

    public static ByteBuffer newByteBuffer(int capacity) {
        return ByteBufferUtil.newByteBuffer(256, capacity);
    }

    public static void copy2Buffer(byte[] src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) {
        dst.reset();
        dst.position(dst.position() + dstOff);
        dst.put(src, srcOff, srcLen);
        dst.reset();
    }

    public static ByteBuffer byte2Buffer(int margin, byte[] buf, int offset, int len) {
        ByteBuffer b = ByteBufferUtil.newByteBuffer(margin, len);
        b.put(buf, offset, len);
        ByteBufferUtil.rewind(b);
        return b;
    }

    public static ByteBuffer byte2Buffer(byte[] data) {
        return ByteBufferUtil.byte2Buffer(256, data, 0, data.length);
    }

    public static ByteBuffer byte2Buffer(byte[] buf, int offset, int len) {
        return ByteBufferUtil.byte2Buffer(256, buf, offset, len);
    }

    public static byte[] buffer2Bytes(ByteBuffer bbuf) {
        byte[] b = new byte[bbuf.remaining()];
        int pos = bbuf.position();
        bbuf.get(b);
        bbuf.position(pos);
        return b;
    }

    public static ByteBuffer enhance(int size, ByteBuffer bbuf) {
        ByteBuffer bbuf2 = ByteBuffer.wrap(new byte[bbuf.capacity() + size]);
        bbuf2.limit(bbuf.limit() + size);
        bbuf2.position(bbuf.position() + size);
        bbuf2.mark();
        bbuf2.put(bbuf);
        ByteBufferUtil.rewind(bbuf2);
        return bbuf2;
    }

    public static ByteBuffer enhance(ByteBuffer bbuf, int size) {
        byte[] b = new byte[bbuf.capacity() + size];
        System.arraycopy(bbuf.array(), 0, b, 0, bbuf.limit());
        ByteBuffer bbuf2 = ByteBuffer.wrap(b);
        bbuf2.limit(bbuf.limit() + size);
        int pos = bbuf.position();
        bbuf.reset();
        int mark = bbuf.position();
        bbuf2.position(mark);
        bbuf2.mark();
        bbuf2.position(pos);
        return bbuf2;
    }

    public static ByteBuffer reserve(int preLen, ByteBuffer bbuf) {
        if (preLen == 0) {
            return bbuf;
        }
        ByteBuffer bbuf2 = bbuf;
        if (preLen > bbuf.position()) {
            int esize = 256 + preLen - bbuf.position();
            bbuf2 = ByteBufferUtil.enhance(esize, bbuf);
        }
        bbuf2.position(bbuf2.position() - preLen);
        bbuf2.mark();
        return bbuf2;
    }

    public static ByteBuffer concat(byte[] pre, ByteBuffer bbuf) {
        ByteBuffer b = ByteBufferUtil.reserve(pre.length, bbuf);
        b.put(pre);
        ByteBufferUtil.rewind(b);
        return b;
    }

    public static ByteBuffer concat(ByteBuffer pre, ByteBuffer bbuf) {
        ByteBuffer b = ByteBufferUtil.reserve(pre.remaining(), bbuf);
        b.put(pre);
        ByteBufferUtil.rewind(pre);
        ByteBufferUtil.rewind(b);
        return b;
    }

    public static ByteBuffer put(ByteBuffer bbuf, byte[] post) {
        ByteBuffer b = bbuf;
        int postLen = post.length;
        if (postLen == 0) {
            return b;
        }
        if (postLen > bbuf.remaining()) {
            int esize = 256 + postLen - bbuf.remaining();
            b = ByteBufferUtil.enhance(bbuf, esize);
        }
        b.put(post);
        return b;
    }

    public static ByteBuffer put(ByteBuffer bbuf, ByteBuffer post) {
        ByteBuffer b = bbuf;
        int postLen = post.remaining();
        if (postLen == 0) {
            return b;
        }
        if (postLen > bbuf.remaining()) {
            int esize = 256 + postLen - bbuf.remaining();
            b = ByteBufferUtil.enhance(bbuf, esize);
        }
        b.put(post);
        ByteBufferUtil.rewind(post);
        return b;
    }

    public static void strip(int preLen, ByteBuffer bbuf) {
        if (preLen == 0) {
            return;
        }
        if (preLen >= bbuf.remaining()) {
            throw new IllegalArgumentException();
        }
        bbuf.position(bbuf.position() + preLen);
        bbuf.mark();
    }

    public static boolean startsWith(byte[] prefix, ByteBuffer bbuf) {
        if (bbuf.remaining() < prefix.length) {
            return false;
        }
        int p = bbuf.position();
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == bbuf.get(p + i)) continue;
            return false;
        }
        return true;
    }
}

