/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;

public class ByteUtil {
    private static final Comparator<byte[]> bytesComparator = new ByteComparator();

    public static Comparator<byte[]> getComparator() {
        return bytesComparator;
    }

    public static int compare(byte[] b1, byte[] b2) {
        assert (b1 != null && b2 != null);
        int cmp = b1.length - b2.length;
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < b1.length; ++i) {
            int v1 = b1[i] & 0xFF;
            int v2 = b2[i] & 0xFF;
            if (v1 == v2) continue;
            return v1 - v2;
        }
        return 0;
    }

    public static int compareAsNumber(byte[] b1, byte[] b2) {
        assert (b1 != null && b2 != null);
        int n = Math.max(b1.length, b2.length);
        int p1 = b1.length - n;
        int p2 = b2.length - n;
        int i = 0;
        while (i < n) {
            int v2;
            int v1 = p1 < 0 ? 0 : b1[p1] & 0xFF;
            int n2 = v2 = p2 < 0 ? 0 : b2[p2] & 0xFF;
            if (v1 != v2) {
                return v1 - v2;
            }
            ++i;
            ++p1;
            ++p2;
        }
        return 0;
    }

    public static boolean equals(byte[] b1, byte[] b2) {
        assert (b1 != null && b2 != null);
        return Arrays.equals(b1, b2);
    }

    public static byte[] concat(byte[] b1, byte[] b2) {
        assert (b1 != null && b2 != null);
        byte[] c = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, c, 0, b1.length);
        System.arraycopy(b2, 0, c, b1.length, b2.length);
        return c;
    }

    public static boolean testBit(byte b, int ix) throws IllegalArgumentException {
        if (ix < 0 || ix >= 8) {
            throw new IllegalArgumentException();
        }
        byte mask = (byte)(1 << 7 - ix);
        return (b & mask) != 0;
    }

    public static boolean testBit(byte[] b, int ix) throws IllegalArgumentException {
        if (ix < 0 || ix >= b.length * 8) {
            throw new IllegalArgumentException();
        }
        int n = ix / 8;
        int m = ix % 8;
        byte mask = (byte)(1 << 7 - m);
        return (b[n] & mask) != 0;
    }

    public static int commonPostfixLen(byte b1, byte b2) {
        int i;
        int xor = b1 ^ b2;
        int mask = 1;
        for (i = 0; i < 8 && (xor & mask) == 0; ++i) {
            mask <<= 1;
        }
        return i;
    }

    public static int commonPostfixLen(byte[] b1, byte[] b2) {
        int len = Math.min(b1.length, b2.length);
        for (int i = 0; i < len; ++i) {
            byte v1 = b1[b1.length - 1 - i];
            byte v2 = b2[b2.length - 1 - i];
            if (v1 == v2) continue;
            return i * 8 + ByteUtil.commonPostfixLen(v1, v2);
        }
        return len * 8;
    }

    public static int commonPrefixLen(byte b1, byte b2) {
        int i;
        int xor = b1 ^ b2;
        int mask = 128;
        for (i = 0; i < 8 && (xor & mask) == 0; ++i) {
            mask >>= 1;
        }
        return i;
    }

    public static int commonPrefixLen(byte[] b1, byte[] b2) {
        int len = Math.min(b1.length, b2.length);
        for (int i = 0; i < len; ++i) {
            byte v1 = b1[i];
            byte v2 = b2[i];
            if (v1 == v2) continue;
            return i * 8 + ByteUtil.commonPrefixLen(v1, v2);
        }
        return len * 8;
    }

    public static int reverse32(int baseno) {
        int result = 0;
        byte[] l = new byte[]{(byte)((long)baseno & 0xFFL), (byte)((long)(baseno >> 8) & 0xFFL), (byte)((long)(baseno >> 16) & 0xFFL), (byte)((long)(baseno >> 24) & 0xFFL)};
        for (int i = 0; i < l.length; ++i) {
            l[i] = ByteUtil.reverse8(l[i]);
        }
        result = l[0];
        result = result << 8 | l[1] & 0xFF;
        result = result << 8 | l[2] & 0xFF;
        result = result << 8 | l[3] & 0xFF;
        return result;
    }

    public static byte reverse8(byte v) {
        byte result = 0;
        result = (byte)(result | (v & 1) << 7);
        result = (byte)(result | (v & 2) << 5);
        result = (byte)(result | (v & 4) << 3);
        result = (byte)(result | (v & 8) << 1);
        result = (byte)(result | (v & 0x10) >> 1);
        result = (byte)(result | (v & 0x20) >> 3);
        result = (byte)(result | (v & 0x40) >> 5);
        result = (byte)(result | (v & 0x80) >> 7);
        return result;
    }

    public static int bytes2Int(byte[] b) {
        return ByteUtil.bytes2Int(b, 0);
    }

    public static int bytes2Int(byte[] b, int off) {
        return (b[off] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static byte[] int2bytes(int x) {
        byte[] b = new byte[4];
        b[3] = (byte)(x & 0xFF);
        b[2] = (byte)((x >>= 8) & 0xFF);
        b[1] = (byte)((x >>= 8) & 0xFF);
        b[0] = (byte)((x >>= 8) & 0xFF);
        return b;
    }

    public static long bytes2Long(byte[] b) {
        return ByteUtil.bytes2Long(b, 0);
    }

    public static long bytes2Long(byte[] b, int off) {
        long l1 = ByteUtil.bytes2Int(b, off);
        long l0 = (long)ByteUtil.bytes2Int(b, off + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public static byte[] long2bytes(long x) {
        byte[] b = new byte[8];
        b[7] = (byte)(x & 0xFFL);
        b[6] = (byte)((x >>= 8) & 0xFFL);
        b[5] = (byte)((x >>= 8) & 0xFFL);
        b[4] = (byte)((x >>= 8) & 0xFFL);
        b[3] = (byte)((x >>= 8) & 0xFFL);
        b[2] = (byte)((x >>= 8) & 0xFFL);
        b[1] = (byte)((x >>= 8) & 0xFFL);
        b[0] = (byte)((x >>= 8) & 0xFFL);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] stream2Bytes(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(in.available());
        byte[] b = new byte[in.available()];
        try {
            int len;
            while ((len = in.read(b)) != -1) {
                bout.write(b, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return bout.toByteArray();
    }

    public static byte[] file2Bytes(File file) throws FileNotFoundException, IOException {
        FileInputStream fin = new FileInputStream(file);
        return ByteUtil.stream2Bytes(fin);
    }

    public static byte[] url2Bytes(URL url) throws FileNotFoundException, IOException {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("URL syntax error");
        }
        return ByteUtil.file2Bytes(file);
    }

    public static void bytes2Stream(byte[] b, OutputStream out) throws IOException {
        try {
            out.write(b);
            out.flush();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void bytes2File(byte[] b, File file) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        ByteUtil.bytes2Stream(b, out);
    }

    public static String byte2Binary(byte b) {
        StringBuilder str = new StringBuilder();
        int mask = 128;
        for (int i = 0; i < 8; ++i) {
            str.append((b & mask) == 0 ? (char)'0' : '1');
            mask >>= 1;
        }
        return str.toString();
    }

    public static String bytes2Binary(byte[] b) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            if (i > 0) {
                str.append('_');
            }
            str.append(ByteUtil.byte2Binary(b[i]));
        }
        return str.toString();
    }

    public static String bytes2Hex(byte[] b) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            int _b = b[i] & 0xFF;
            char upper = Character.forDigit(_b / 16, 16);
            char lower = Character.forDigit(_b % 16, 16);
            str.append(upper);
            str.append(lower);
        }
        return str.toString();
    }

    public static byte[] hexBytes2Bytes(byte[] hex) {
        byte[] b = new byte[hex.length / 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            int upper = Character.digit(hex[j++], 16);
            int lower = Character.digit(hex[j++], 16);
            b[i] = (byte)(16 * upper + lower);
        }
        return b;
    }

    public static byte[] hex2Bytes(String s) throws IllegalArgumentException {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            String ss = null;
            try {
                ss = s.substring(i * 2, i * 2 + 2);
                b[i] = (byte)Integer.parseInt(ss, 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException();
            }
        }
        return b;
    }

    public static boolean isASCII(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if ((b[i] & 0x80) == 0) continue;
            return false;
        }
        return true;
    }

    public static String dumpBytes(byte[] b, int offset, int len) {
        StringBuilder str = new StringBuilder();
        for (int i = offset; i < offset + len; ++i) {
            int _b = b[i] & 0xFF;
            if (_b >= 32 && _b <= 126) {
                str.append((char)_b);
                continue;
            }
            char upper = Character.forDigit(_b / 16, 16);
            char lower = Character.forDigit(_b % 16, 16);
            str.append('.');
            str.append(upper);
            str.append(lower);
        }
        return str.toString();
    }

    public static String dumpBytes(byte[] b) {
        return ByteUtil.dumpBytes(b, 0, b.length);
    }

    public static String dumpBytes(ByteBuffer bbuf) {
        StringBuilder str = new StringBuilder();
        int len = bbuf.remaining();
        ByteBuffer b = bbuf.slice();
        for (int i = 0; i < len; ++i) {
            int _b = b.get() & 0xFF;
            if (_b >= 32 && _b <= 126) {
                str.append((char)_b);
                continue;
            }
            char upper = Character.forDigit(_b / 16, 16);
            char lower = Character.forDigit(_b % 16, 16);
            str.append('.');
            str.append(upper);
            str.append(lower);
        }
        return str.toString();
    }

    public static boolean startsWith(byte[] b, byte[] prefix) {
        if (b.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] b, byte x) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != x) continue;
            return i;
        }
        return -1;
    }

    public static int encode4escape(byte[] b, int len, byte[] buf, byte[] escapeAndElimBytes) throws ArrayIndexOutOfBoundsException {
        byte escape = escapeAndElimBytes[0];
        byte[] escapeCodes = new byte[escapeAndElimBytes.length];
        byte ecode = 1;
        for (int i = 0; i < escapeAndElimBytes.length; ++i) {
            while (ByteUtil.indexOf(escapeAndElimBytes, ecode) >= 0) {
                ecode = (byte)(ecode + 1);
            }
            byte by = ecode;
            ecode = (byte)(ecode + 1);
            escapeCodes[i] = by;
        }
        int bufIx = 0;
        for (int i = 0; i < len; ++i) {
            int ix = ByteUtil.indexOf(escapeAndElimBytes, b[i]);
            if (ix == -1) {
                buf[bufIx++] = b[i];
                continue;
            }
            buf[bufIx++] = escape;
            buf[bufIx++] = escapeCodes[ix];
        }
        return bufIx;
    }

    public static int decode4escape(byte[] b, int len, byte[] buf, byte[] escapeAndElimBytes) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        byte escape = escapeAndElimBytes[0];
        byte[] escapeCodes = new byte[escapeAndElimBytes.length];
        byte ecode = 1;
        for (int i = 0; i < escapeAndElimBytes.length; ++i) {
            while (ByteUtil.indexOf(escapeAndElimBytes, ecode) >= 0) {
                ecode = (byte)(ecode + 1);
            }
            byte by = ecode;
            ecode = (byte)(ecode + 1);
            escapeCodes[i] = by;
        }
        int bufIx = 0;
        for (int i = 0; i < len; ++i) {
            int ix;
            if (b[i] != escape) {
                buf[bufIx++] = b[i];
                continue;
            }
            if ((ix = ByteUtil.indexOf(escapeCodes, b[++i])) == -1) {
                throw new IllegalArgumentException("invalid source bytes");
            }
            buf[bufIx++] = escapeAndElimBytes[ix];
        }
        return bufIx;
    }

    private static class ByteComparator
    implements Comparator<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ByteComparator() {
        }

        @Override
        public int compare(byte[] b1, byte[] b2) {
            return ByteUtil.compare(b1, b2);
        }
    }
}

