/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class ClassPathUtil {
    public static File[] toFiles(String classPath) throws IllegalArgumentException {
        String[] paths = classPath.split(File.pathSeparator);
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]);
            if (files[i].exists()) continue;
            throw new IllegalArgumentException("Unknown path:" + paths[i]);
        }
        return files;
    }

    public static URL[] toURLs(File[] paths) throws IllegalArgumentException {
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            try {
                urls[i] = paths[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid File:" + paths[i]);
            }
        }
        return urls;
    }

    public static File[] toFiles(URL[] urls) throws URISyntaxException {
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = new File(urls[i].toURI());
        }
        return files;
    }

    public static long lastModified(File dir) {
        long mtime = 0L;
        File[] subFiles = dir.listFiles();
        if (subFiles == null) {
            return 0L;
        }
        for (File sub : subFiles) {
            if (sub.isDirectory()) {
                mtime = Math.max(mtime, ClassPathUtil.lastModified(sub));
                continue;
            }
            if (!sub.getName().endsWith(".class") && !sub.getName().endsWith(".CLASS")) continue;
            mtime = Math.max(mtime, sub.lastModified());
        }
        return mtime;
    }

    public static long lastModified(File[] paths) {
        long mtime = 0L;
        for (File path : paths) {
            if (path.isDirectory()) {
                mtime = Math.max(mtime, ClassPathUtil.lastModified(path));
                continue;
            }
            if (!path.getName().endsWith(".jar") && !path.getName().endsWith(".JAR")) continue;
            mtime = Math.max(mtime, path.lastModified());
        }
        return mtime;
    }
}

