/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.Comparator;
import org.piax.common.ComparableKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyComparator
implements Comparator<Comparable<?>> {
    private static final Logger logger = LoggerFactory.getLogger(KeyComparator.class);
    private static KeyComparator instance = new KeyComparator();

    public static KeyComparator getInstance() {
        return instance;
    }

    public static Infinity getPlusInfinity(Class<?> clazz) {
        return new Infinity(clazz, true);
    }

    public static Infinity getMinusInfinity(Class<?> clazz) {
        return new Infinity(clazz, false);
    }

    private KeyComparator() {
    }

    @Override
    public int compare(Comparable<?> key1, Comparable<?> key2) {
        if (key1 instanceof Infinity) {
            logger.debug("key1:{}", key1);
            Infinity k1 = (Infinity)key1;
            if (key2 instanceof Infinity) {
                logger.debug("key2:{}", key2);
                return k1.compareTo((Infinity)key2);
            }
            if (k1.clazz == key2.getClass()) {
                return k1.isPlus ? 1 : -1;
            }
            return k1.clazz.getName().compareTo(key2.getClass().getName());
        }
        if (key2 instanceof Infinity) {
            logger.debug("key2:{}", key2);
            Infinity k2 = (Infinity)key2;
            if (key1.getClass() == k2.clazz) {
                return k2.isPlus ? -1 : 1;
            }
            return key1.getClass().getName().compareTo(k2.clazz.getName());
        }
        if (key1.getClass() == key2.getClass()) {
            Comparable<?> k1 = key1;
            return k1.compareTo(key2);
        }
        return key1.getClass().getName().compareTo(key2.getClass().getName());
    }

    public boolean isOrdered(Comparable<?> a, Comparable<?> b, Comparable<?> c) {
        if (this.compare(a, b) <= 0 && this.compare(b, c) <= 0) {
            return true;
        }
        if (this.compare(b, c) <= 0 && this.compare(c, a) <= 0) {
            return true;
        }
        return this.compare(c, a) <= 0 && this.compare(a, b) <= 0;
    }

    public static class Infinity
    implements ComparableKey<Infinity> {
        private static final long serialVersionUID = 1L;
        public final Class<?> clazz;
        public final boolean isPlus;

        private Infinity(Class<?> clazz, boolean isPlus) {
            this.clazz = clazz;
            this.isPlus = isPlus;
        }

        public int hashCode() {
            return this.clazz.hashCode() + (this.isPlus ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Infinity other = (Infinity)o;
            return this.clazz == other.clazz && this.isPlus == other.isPlus;
        }

        @Override
        public int compareTo(Infinity o) {
            if (this.clazz == o.clazz) {
                return (this.isPlus ? 1 : 0) - (o.isPlus ? 1 : 0);
            }
            return this.clazz.getName().compareTo(o.clazz.getName());
        }

        public String toString() {
            return (this.isPlus ? "+inf(" : "-inf(") + this.clazz.getSimpleName() + ")";
        }
    }
}

