/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalInetAddrs {
    private static final Logger logger = LoggerFactory.getLogger(LocalInetAddrs.class);
    public static final long NO_LISTUP_PERIOD = 5000L;
    private static long listedUpTime = 0L;
    private static List<InetAddress> linkLocals = new ArrayList<InetAddress>();
    private static List<InetAddress> siteLocals = new ArrayList<InetAddress>();
    private static List<InetAddress> globals = new ArrayList<InetAddress>();

    private static void listup() {
        Enumeration<NetworkInterface> netIfs;
        long thisTime = System.currentTimeMillis();
        if (thisTime - listedUpTime < 5000L) {
            return;
        }
        listedUpTime = thisTime;
        linkLocals.clear();
        siteLocals.clear();
        globals.clear();
        try {
            netIfs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.error("", (Throwable)e);
            return;
        }
        if (netIfs == null) {
            logger.warn("there is NO network I/F");
            return;
        }
        while (netIfs.hasMoreElements()) {
            NetworkInterface netIf = netIfs.nextElement();
            try {
                if (!netIf.isUp() || netIf.isVirtual()) {
                    continue;
                }
            }
            catch (SocketException e) {
                logger.error("", (Throwable)e);
                return;
            }
            Enumeration<InetAddress> inetAddrs = netIf.getInetAddresses();
            while (inetAddrs.hasMoreElements()) {
                InetAddress inetAddr = inetAddrs.nextElement();
                if (inetAddr instanceof Inet6Address || inetAddr.isLoopbackAddress()) continue;
                if (inetAddr.isLinkLocalAddress()) {
                    linkLocals.add(inetAddr);
                    continue;
                }
                if (inetAddr.isSiteLocalAddress()) {
                    siteLocals.add(inetAddr);
                    continue;
                }
                globals.add(inetAddr);
            }
        }
    }

    public static synchronized boolean isLocal(InetAddress target) {
        LocalInetAddrs.listup();
        String address = target.getHostAddress();
        for (InetAddress addr : globals) {
            if (!address.equals(addr.getHostAddress())) continue;
            return true;
        }
        for (InetAddress addr : siteLocals) {
            if (!address.equals(addr.getHostAddress())) continue;
            return true;
        }
        for (InetAddress addr : linkLocals) {
            if (!address.equals(addr.getHostAddress())) continue;
            return true;
        }
        return target.isLoopbackAddress();
    }

    public static synchronized InetAddress choice() {
        LocalInetAddrs.listup();
        if (globals.size() > 0) {
            return globals.get(0);
        }
        if (siteLocals.size() > 0) {
            return siteLocals.get(0);
        }
        if (linkLocals.size() > 0) {
            return linkLocals.get(0);
        }
        try {
            return InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static synchronized InetAddress choiceIfIsLocal(InetAddress target) {
        if (LocalInetAddrs.isLocal(target)) {
            return LocalInetAddrs.choice();
        }
        return target;
    }
}

