/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilter
implements Filter {
    public static Level defaultLevel = LogFilter.getLevel("info");
    public static Map<String, Level> logLevelMap = new HashMap<String, Level>();

    @Override
    public boolean isLoggable(LogRecord record) {
        String levelStr;
        LogManager lm = LogManager.getLogManager();
        String defaultLevelStr = lm.getProperty(".loglevel");
        if (defaultLevelStr != null) {
            defaultLevel = LogFilter.getLevel(defaultLevelStr);
        }
        if ((levelStr = lm.getProperty(record.getLoggerName() + ".loglevel")) != null) {
            Level l = LogFilter.getLevel(levelStr);
            return l != null && l.intValue() <= record.getLevel().intValue();
        }
        return defaultLevel.intValue() <= record.getLevel().intValue();
    }

    public static Level getLevel(String l) {
        Level ret = defaultLevel;
        if (l.equals("error")) {
            ret = Level.SEVERE;
        } else if (l.equals("warn")) {
            ret = Level.WARNING;
        } else if (l.equals("info")) {
            ret = Level.INFO;
        } else if (l.equals("debug")) {
            ret = Level.FINE;
        } else if (l.equals("trace")) {
            ret = Level.FINEST;
        }
        return ret;
    }

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(LogFilter.class);
        logger.debug("debug {}", (Object)"message");
        logger.info("info {}", (Object)"message");
        logger.warn("warn {}", (Object)"message");
        logger.error("error {}", (Object)"message");
        logger.trace("trace {}", (Object)"message");
    }

    public static enum LogLevel {
        error,
        warn,
        info,
        debug,
        trace;

    }
}

