/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.Random;

public class MersenneTwister
extends Random {
    private static final long serialVersionUID = -3517094166157065652L;
    static final int N = 624;
    static final int M = 397;
    static final int UPPER_MASK = Integer.MIN_VALUE;
    static final int LOWER_MASK = Integer.MAX_VALUE;
    static final int MATRIX_A = -1727483681;
    int[] x = new int[624];
    int p;
    int q;
    int r;

    public MersenneTwister() {
        this.setSeed(System.currentTimeMillis());
    }

    public MersenneTwister(long seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(int[] seeds) {
        this.setSeed(seeds);
    }

    @Override
    public synchronized void setSeed(long seed) {
        if (this.x == null) {
            return;
        }
        this.x[0] = (int)seed;
        int i = 1;
        while (i < 624) {
            this.x[i] = 1812433253 * (this.x[i - 1] ^ this.x[i - 1] >>> 30) + i;
            int n = i++;
            this.x[n] = this.x[n] & 0xFFFFFFFF;
        }
        this.p = 0;
        this.q = 1;
        this.r = 397;
    }

    public synchronized void setSeed(int[] seeds) {
        int k;
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        for (k = 0; k < Math.max(624, seeds.length); ++k) {
            int n = i;
            this.x[n] = this.x[n] ^ (this.x[i - 1] ^ this.x[i - 1] >>> 30) * 1664525;
            int n2 = i;
            this.x[n2] = this.x[n2] + (seeds[j] + j);
            int n3 = i++;
            this.x[n3] = this.x[n3] & 0xFFFFFFFF;
            if (i >= 624) {
                this.x[0] = this.x[623];
                i = 1;
            }
            if (++j < seeds.length) continue;
            j = 0;
        }
        for (k = 0; k < 623; ++k) {
            int n = i;
            this.x[n] = this.x[n] ^ (this.x[i - 1] ^ this.x[i - 1] >>> 30) * 1566083941;
            int n4 = i;
            this.x[n4] = this.x[n4] - i;
            int n5 = i++;
            this.x[n5] = this.x[n5] & 0xFFFFFFFF;
            if (i < 624) continue;
            this.x[0] = this.x[623];
            i = 1;
        }
        this.x[0] = Integer.MIN_VALUE;
    }

    @Override
    protected synchronized int next(int bits) {
        int y = this.x[this.p] & Integer.MIN_VALUE | this.x[this.q] & Integer.MAX_VALUE;
        y = this.x[this.p] = this.x[this.r] ^ y >>> 1 ^ (y & 1) * -1727483681;
        if (++this.p == 624) {
            this.p = 0;
        }
        if (++this.q == 624) {
            this.q = 0;
        }
        if (++this.r == 624) {
            this.r = 0;
        }
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }
}

