/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.WeakHashMap;
import org.piax.gtrans.IllegalRPCAccessException;
import org.piax.gtrans.RemoteCallable;
import org.piax.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodUtil.class);
    private static WeakHashMap<MethodKey, Method[]> methodCache = new WeakHashMap();

    private static Method[] getMethods(Class<?> clazz, Class<?> superIf, String methodName, int paramNum) {
        MethodKey key = new MethodKey(clazz, superIf, methodName, paramNum);
        Method[] invocableMethods = methodCache.get(key);
        if (invocableMethods == null) {
            Class[] classArray;
            if (superIf == null) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = clazz;
            } else {
                classArray = ClassUtil.gatherLowerBoundSuperInterfaces(clazz, superIf);
            }
            Class[] classes = classArray;
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Class cls : classes) {
                Method[] ms;
                for (Method method : ms = cls.getMethods()) {
                    if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) continue;
                    if (method.isVarArgs()) {
                        methods.add(method);
                        continue;
                    }
                    Class<?>[] params = method.getParameterTypes();
                    if (params.length != paramNum) continue;
                    methods.add(method);
                }
            }
            invocableMethods = new Method[methods.size()];
            methods.toArray(invocableMethods);
            methodCache.put(key, invocableMethods);
        }
        return invocableMethods;
    }

    private static Class<?> boxing(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    private static <T> boolean isAssignable(Object arg, Class<T> paramType) {
        Class<Object> _paramType;
        if (arg == null) {
            return !paramType.isPrimitive();
        }
        Class<?> argType = arg.getClass();
        if (paramType == argType) {
            return true;
        }
        Class<Object> clazz = _paramType = paramType.isPrimitive() ? MethodUtil.boxing(paramType) : paramType;
        return _paramType.isAssignableFrom(argType);
    }

    private static Method getMethod(Class<?> clazz, Class<?> superIf, String methodName, Object ... args) {
        Method[] invocableMethods;
        for (Method method : invocableMethods = MethodUtil.getMethods(clazz, superIf, methodName, args.length)) {
            int i;
            Class<?>[] paramTypes = method.getParameterTypes();
            boolean matched = true;
            if (!method.isVarArgs()) {
                for (i = 0; i < args.length; ++i) {
                    if (MethodUtil.isAssignable(args[i], paramTypes[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return method;
            }
            if (args.length == paramTypes.length - 1) {
                for (i = 0; i < args.length; ++i) {
                    if (MethodUtil.isAssignable(args[i], paramTypes[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return method;
            }
            if (args.length == paramTypes.length) {
                for (i = 0; i < args.length - 1; ++i) {
                    if (MethodUtil.isAssignable(args[i], paramTypes[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                if (MethodUtil.isAssignable(args[i], paramTypes[i].getComponentType())) {
                    return method;
                }
                if (!MethodUtil.isAssignable(args[i], paramTypes[i])) continue;
                logger.debug("packed VarArgs case");
                return method;
            }
            for (i = 0; i < args.length; ++i) {
                Class<?> paramType = null;
                paramType = i < paramTypes.length - 1 ? paramTypes[i] : paramTypes[paramTypes.length - 1].getComponentType();
                if (MethodUtil.isAssignable(args[i], paramType)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return method;
        }
        return null;
    }

    public static Object invoke(Object target, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException {
        return MethodUtil.invoke(target, null, methodName, args);
    }

    private static void checkRemoteCallable(Method method) {
        RemoteCallable anno = method.getAnnotation(RemoteCallable.class);
        if (anno == null) {
            throw new IllegalRPCAccessException("could not call remotely without RemoteCallable annotation");
        }
    }

    public static Object invoke(Object target, Class<?> superIf, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException {
        return MethodUtil.invoke(target, superIf, true, methodName, args);
    }

    public static Object invoke(Object target, Class<?> superIf, boolean localCall, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException {
        Object[] _args = args == null ? new Object[]{} : args;
        Method method = MethodUtil.getMethod(target.getClass(), superIf, methodName, _args);
        if (method == null) {
            throw new NoSuchMethodException(methodName + " in " + target.getClass().getName());
        }
        try {
            if (!localCall) {
                MethodUtil.checkRemoteCallable(method);
            }
            if (method.isVarArgs()) {
                Class<?>[] ptypes = method.getParameterTypes();
                int arrIx = ptypes.length - 1;
                if (arrIx == _args.length - 1 && ptypes[arrIx].isAssignableFrom(_args[arrIx].getClass())) {
                    return method.invoke(target, _args);
                }
                Object arr = Array.newInstance(ptypes[arrIx].getComponentType(), _args.length - arrIx);
                for (int i = 0; i < _args.length - arrIx; ++i) {
                    Array.set(arr, i, _args[i + arrIx]);
                }
                Object[] args1 = new Object[arrIx + 1];
                for (int i = 0; i < arrIx; ++i) {
                    args1[i] = _args[i];
                }
                args1[arrIx] = arr;
                return method.invoke(target, args1);
            }
            return method.invoke(target, _args);
        }
        catch (IllegalArgumentException e) {
            logger.error("", (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            logger.error("", (Throwable)e);
            throw new NoSuchMethodException(methodName + " in " + target.getClass().getName());
        }
    }

    public static Method strictGetMethod(Class<?> targetClass, Class<?> superIf, String methodName, Object ... args) throws NoSuchMethodException {
        Object[] _args = args == null ? new Object[]{} : args;
        Method[] invocableMethods = MethodUtil.getMethods(targetClass, superIf, methodName, _args.length);
        if (invocableMethods.length == 1) {
            return invocableMethods[0];
        }
        if (invocableMethods.length > 1) {
            for (Method method : invocableMethods) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (_args.length != paramTypes.length) continue;
                boolean matched = true;
                for (int i = 0; i < _args.length; ++i) {
                    if (MethodUtil.isAssignable(_args[i], paramTypes[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return method;
            }
        }
        throw new NoSuchMethodException(methodName + " in " + targetClass.getName());
    }

    public static Object strictInvoke(Object target, Class<?> superIf, boolean localCall, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException {
        Method method = MethodUtil.strictGetMethod(target.getClass(), superIf, methodName, args);
        try {
            if (!localCall) {
                MethodUtil.checkRemoteCallable(method);
            }
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            logger.error("", (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            logger.error("", (Throwable)e);
            throw new NoSuchMethodException(methodName + " in " + target.getClass().getName());
        }
    }

    private static class MethodKey {
        final Class<?> clazz;
        final Class<?> superIf;
        final String methodName;
        final int paramNum;

        MethodKey(Class<?> clazz, Class<?> superIf, String methodName, int paramNum) {
            this.clazz = clazz;
            this.superIf = superIf;
            this.methodName = methodName;
            this.paramNum = paramNum;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MethodKey)) {
                return false;
            }
            MethodKey mkey = (MethodKey)o;
            return this.clazz == mkey.clazz && this.superIf == mkey.superIf && this.methodName.equals(mkey.methodName) && this.paramNum == mkey.paramNum;
        }

        public int hashCode() {
            return this.clazz.hashCode() ^ (this.superIf == null ? 0 : this.superIf.hashCode()) ^ this.methodName.hashCode() ^ this.paramNum;
        }
    }
}

