/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.common.PeerId;
import org.piax.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIAXThreadPool
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PIAXThreadPool.class);
    public static int CORE_POOL_SIZE = 10;
    public static int MAX_POOL_SIZE = 2000;
    public static long THREAD_KEEP_ALIVE_TIME = 600000L;
    public static String THREAD_NAME_PREFIX = "thPool-";
    public static final long MAX_WAIT_TIME_FOR_TERMINATION = 100L;

    public PIAXThreadPool() {
        this(CORE_POOL_SIZE, MAX_POOL_SIZE, THREAD_KEEP_ALIVE_TIME, THREAD_NAME_PREFIX, 5);
    }

    public PIAXThreadPool(int maxPoolSize, String threadNamePrefix) {
        this(CORE_POOL_SIZE, maxPoolSize, THREAD_KEEP_ALIVE_TIME, threadNamePrefix, 5);
    }

    public PIAXThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, String threadNamePrefix, int threadPriority) {
        super(Math.min(corePoolSize, maxPoolSize), maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new _ThreadFactory(threadNamePrefix, threadPriority), new ThreadPoolExecutor.AbortPolicy());
    }

    public void execute(PeerId peerId, Runnable task) throws RejectedExecutionException {
        try {
            super.execute(new ThreadUtil._Runnable(peerId, task));
        }
        catch (RejectedExecutionException e) {
            if (this.isShutdown()) {
                logger.info("message discarded as this thread pool is shutdown");
            }
            throw e;
        }
    }

    @Override
    public void execute(Runnable task) throws RejectedExecutionException {
        try {
            super.execute(task);
        }
        catch (RejectedExecutionException e) {
            if (this.isShutdown()) {
                logger.info("message discarded as this thread pool is shutdown");
            }
            throw e;
        }
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        try {
            super.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("some tasks not terminated");
        }
    }

    private static class _ThreadFactory
    implements ThreadFactory {
        final AtomicInteger thNum = new AtomicInteger(1);
        final String namePrefix;
        final int priority;

        _ThreadFactory(String namePrefix, int priority) {
            this.namePrefix = namePrefix;
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.thNum.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            t.setPriority(this.priority);
            return t;
        }
    }
}

