/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.Timer;
import org.piax.common.PeerId;

public class ThreadUtil {
    private static String ID_SEPARATOR_IN_THREADNAME = ":";

    public static void concatPeerId2ThreadName(PeerId peerId) {
        String currName = Thread.currentThread().getName();
        int ix = currName.lastIndexOf(ID_SEPARATOR_IN_THREADNAME);
        if (ix != -1) {
            currName = currName.substring(0, ix);
        }
        Thread.currentThread().setName(currName + ID_SEPARATOR_IN_THREADNAME + peerId);
    }

    private static String clipPeerIdFromCurrentThreadName() {
        String currName = Thread.currentThread().getName();
        int ix = currName.lastIndexOf(ID_SEPARATOR_IN_THREADNAME);
        if (ix != -1) {
            return currName.substring(ix + 1, currName.length());
        }
        return "";
    }

    public static class _Timer
    extends Timer {
        public _Timer(String name, boolean isDaemon) {
            super(name + ":" + ThreadUtil.clipPeerIdFromCurrentThreadName(), isDaemon);
        }

        public _Timer(PeerId peerId, String name, boolean isDaemon) {
            super(name + ":" + peerId, isDaemon);
        }
    }

    public static class _Runnable
    implements Runnable {
        private final PeerId peerId;
        private final Runnable runnable;

        public _Runnable(PeerId peerId, Runnable runnable) {
            this.peerId = peerId;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            ThreadUtil.concatPeerId2ThreadName(this.peerId);
            this.runnable.run();
        }
    }
}

