/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.ObjectStreamException;
import org.piax.common.ComparableKey;
import org.piax.common.Endpoint;
import org.piax.common.Id;

public class UniqId
extends Id
implements Endpoint,
ComparableKey<Id> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BYTE_LENGTH = 16;
    public static final UniqId MINUS_INFINITY = new SpecialId(0);
    public static final UniqId PLUS_INFINITY = new SpecialId(1);
    private static final String MINUS_INFINITY_STRING = "-infinity";
    private static final String PLUS_INFINITY_STRING = "+infinity";

    public static UniqId newId() {
        return new UniqId(UniqId.newRandomBytes(16));
    }

    public UniqId(Id id) {
        super(id.getBytes());
    }

    public UniqId(byte[] bytes) {
        super(bytes);
    }

    public UniqId(String str) {
        super(str);
    }

    @Override
    public boolean equals(Object id) {
        if (this == PLUS_INFINITY && id != PLUS_INFINITY) {
            return false;
        }
        if (this == MINUS_INFINITY && id != MINUS_INFINITY) {
            return false;
        }
        return super.equals(id);
    }

    @Override
    public int compareTo(Id id) {
        if (this == id) {
            return 0;
        }
        if (this == PLUS_INFINITY || id == MINUS_INFINITY) {
            return 1;
        }
        if (id == PLUS_INFINITY || this == MINUS_INFINITY) {
            return -1;
        }
        return super.compareTo(id);
    }

    @Override
    public String toString() {
        if (this == MINUS_INFINITY) {
            return MINUS_INFINITY_STRING;
        }
        if (this == PLUS_INFINITY) {
            return PLUS_INFINITY_STRING;
        }
        return super.toString();
    }

    private static final class SpecialId
    extends UniqId {
        private static final long serialVersionUID = 1L;

        private SpecialId(int b) {
            super(new byte[]{(byte)b});
        }

        private Object readResolve() throws ObjectStreamException {
            if (this instanceof SpecialId) {
                if (this.bytes[0] == 0) {
                    return MINUS_INFINITY;
                }
                if (this.bytes[0] == 1) {
                    return PLUS_INFINITY;
                }
            }
            return this;
        }
    }
}

