/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.Option;
import org.piax.common.PeerId;
import org.piax.common.StatusRepo;
import org.piax.common.TransportId;
import org.piax.common.TransportIdPath;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.BaseTransportGenerator;
import org.piax.gtrans.impl.BaseTransportMgr;
import org.piax.gtrans.impl.IdResolver;
import org.piax.gtrans.impl.ReceiverThreadPool;
import org.piax.gtrans.impl.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    public static final String RAW = "RAW";
    public static final String WITH_FRAGMENTATION = "WITH_FRAGMENTATION";
    public static final Option.BooleanOption RECEIVE_ASYNC = new Option.BooleanOption(false, "-receive-async");
    static final ConcurrentMap<PeerId, Peer> peers = new ConcurrentHashMap<PeerId, Peer>();
    final ConcurrentNavigableMap<TransportIdPath, Transport<?>> transports = new ConcurrentSkipListMap();
    final Set<TransportIdPath> baseOverlays = new CopyOnWriteArraySet<TransportIdPath>();
    final ConcurrentMap<ObjectId, Object> rpcObjects = new ConcurrentHashMap<ObjectId, Object>();
    final IdResolver idResolver;
    final BaseTransportMgr baseTransMgr;
    private StatusRepo repo = null;
    final ReceiverThreadPool threadPool;
    final PeerId peerId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer getInstance(PeerId peerId) {
        ConcurrentMap<PeerId, Peer> concurrentMap = peers;
        synchronized (concurrentMap) {
            Peer peer = (Peer)peers.get(peerId);
            if (peer != null) {
                return peer;
            }
            peer = new Peer(peerId);
            peers.put(peerId, peer);
            return peer;
        }
    }

    protected Peer(PeerId peerId) {
        this.peerId = peerId;
        this.idResolver = new IdResolver(peerId);
        this.baseTransMgr = new BaseTransportMgr(this);
        this.threadPool = new ReceiverThreadPool();
        this.concatPeerId2ThreadName();
        logger.trace("EXIT:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fin() {
        ConcurrentMap<PeerId, Peer> concurrentMap = peers;
        synchronized (concurrentMap) {
            for (Transport trans : this.transports.descendingMap().values()) {
                trans.fin();
            }
            this.transports.size();
            if (this.repo != null) {
                this.repo.fin();
                this.repo = null;
            }
            if (peers.remove(this.peerId, this)) {
                this.threadPool.fin();
            }
        }
        logger.trace("EXIT:");
    }

    public PeerId getPeerId() {
        return this.peerId;
    }

    public StatusRepo getStatusRepo() throws IOException {
        if (this.repo != null) {
            return this.repo;
        }
        this.repo = new StatusRepo(this.peerId.toString());
        return this.repo;
    }

    public IdResolver getIdResolver() {
        return this.idResolver;
    }

    public BaseTransportMgr getBaseTransportMgr() {
        return this.baseTransMgr;
    }

    public void addBaseTransportGenerator(BaseTransportGenerator generator) {
        this.baseTransMgr.addBaseTransportGenerator(generator);
    }

    public void addFirstBaseTransportGenerator(BaseTransportGenerator generator) {
        this.baseTransMgr.addFirstBaseTransportGenerator(generator);
    }

    public <E extends Endpoint> Transport<E> newBaseTransport(E locator) throws IOException, IdConflictException {
        return this.newBaseTransport(null, null, locator);
    }

    public <E extends Endpoint> Transport<E> newBaseTransport(String desc, E locator) throws IOException, IdConflictException {
        return this.newBaseTransport(desc, null, locator);
    }

    public <E extends Endpoint> Transport<E> newBaseTransport(String desc, TransportId transId, E locator) throws IOException, IdConflictException {
        return this.baseTransMgr.newBaseTransport(desc, transId, locator);
    }

    public <E extends Endpoint> ChannelTransport<E> newBaseChannelTransport(E locator) throws IOException, IdConflictException {
        return this.newBaseChannelTransport(null, null, locator);
    }

    public <E extends Endpoint> ChannelTransport<E> newBaseChannelTransport(String desc, E locator) throws IOException, IdConflictException {
        return this.newBaseChannelTransport(desc, null, locator);
    }

    public <E extends Endpoint> ChannelTransport<E> newBaseChannelTransport(String desc, TransportId transId, E locator) throws IOException, IdConflictException {
        return this.baseTransMgr.newBaseChannelTransport(desc, transId, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransport(TransportIdPath transIdPath, Transport<?> trans) throws IdConflictException {
        ConcurrentNavigableMap<TransportIdPath, Transport<?>> concurrentNavigableMap = this.transports;
        synchronized (concurrentNavigableMap) {
            if (this.transports.get(transIdPath) != null) {
                throw new IdConflictException("This transport is already registered: " + transIdPath);
            }
            this.transports.put(transIdPath, trans);
        }
        logger.trace("EXIT:");
    }

    public boolean unregisterTransport(TransportIdPath transIdPath, Transport<?> trans) {
        logger.trace("EXIT:");
        return this.transports.remove(transIdPath, trans);
    }

    public List<Transport<?>> getAllTransports() {
        return new ArrayList(this.transports.values());
    }

    public Transport<?> getTransport(TransportIdPath transIdPath) {
        return (Transport)this.transports.get(transIdPath);
    }

    public List<Transport<?>> getMatchedTransport(TransportId ... suffix) {
        TransportIdPath _suffix = new TransportIdPath(suffix);
        return this.getMatchedTransport(_suffix);
    }

    public List<Transport<?>> getMatchedTransport(TransportIdPath suffix) {
        ArrayList trans = new ArrayList();
        for (Map.Entry ent : this.transports.entrySet()) {
            if (!((TransportIdPath)ent.getKey()).matches(suffix)) continue;
            trans.add((Transport)ent.getValue());
        }
        return trans;
    }

    private static void addIndent(StringBuilder sb, int n) {
        int i = 0;
        while (i < n) {
            sb.append(' ');
            ++i;
        }
    }

    private void genTransportTree(int level, List<TransportTreeNode> list, TransportImpl<?> tr) {
        list.add(new TransportTreeNode(level, tr));
        for (TransportImpl<?> upper : tr.getUppers()) {
            this.genTransportTree(level + 1, list, upper);
        }
    }

    public List<TransportTreeNode> genTransportTree() {
        ArrayList<TransportTreeNode> list = new ArrayList<TransportTreeNode>();
        for (Transport<?> tr : this.getAllTransports()) {
            if (tr.getLowerTransport() != null) continue;
            logger.debug("base tr:{}", tr);
            if (!(tr instanceof TransportImpl)) {
                logger.info("{} should be instance of TransportImpl", tr);
                continue;
            }
            this.genTransportTree(0, list, (TransportImpl)tr);
        }
        return list;
    }

    public String printTransportTree() {
        StringBuilder sb = new StringBuilder();
        for (TransportTreeNode nd : this.genTransportTree()) {
            Peer.addIndent(sb, nd.level * 4);
            sb.append(nd.trans.getClass().getSimpleName());
            sb.append("{\"" + nd.trans.getTransportId() + "\"}\n");
        }
        return sb.toString();
    }

    public void registerBaseOverlay(TransportIdPath transIdPath) {
        this.baseOverlays.add(transIdPath);
        logger.trace("EXIT:");
    }

    public boolean unregisterBaseOverlay(TransportIdPath transIdPath) {
        logger.trace("EXIT:");
        return this.baseOverlays.remove(transIdPath);
    }

    public Set<TransportIdPath> getBaseOverlays() {
        return this.baseOverlays;
    }

    public void registerRPCObject(ObjectId objId, Object obj) throws IdConflictException {
        if (this.rpcObjects.putIfAbsent(objId, obj) != null) {
            throw new IdConflictException("This RPC object is already registered: " + objId);
        }
        logger.trace("EXIT:");
    }

    public boolean unregisterRPCObject(ObjectId objId, Object obj) {
        logger.trace("EXIT:");
        return this.rpcObjects.remove(objId, obj);
    }

    public Object getRPCObject(ObjectId objId) {
        return this.rpcObjects.get(objId);
    }

    public void execute(Runnable receiveTask) throws RejectedExecutionException {
        if (((Boolean)RECEIVE_ASYNC.value()).booleanValue()) {
            this.threadPool.execute(receiveTask);
        } else {
            receiveTask.run();
        }
    }

    public void concatPeerId2ThreadName() {
        String currName = Thread.currentThread().getName();
        int ix = currName.indexOf(58);
        if (ix != -1) {
            currName = currName.substring(0, ix);
        }
        Thread.currentThread().setName(String.valueOf(currName) + ':' + this.peerId);
    }

    public String toString() {
        return "Peer{peerId=" + this.peerId + ", \n    transports=" + this.getAllTransports() + ", \n    baseTransports=" + this.baseTransMgr.getBaseTransportIdPaths() + ", \n    baseOverlays=" + this.baseOverlays + ", \n    rpcObjects=" + this.rpcObjects.keySet() + "}";
    }

    @Override
    public void close() throws IOException {
        this.fin();
    }

    public static class TransportTreeNode {
        public final int level;
        public final Transport<?> trans;

        TransportTreeNode(int level, Transport<?> trans) {
            this.level = level;
            this.trans = trans;
        }
    }
}

