/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.gtrans.Transport;

public abstract class PeerLocator
implements Endpoint {
    private static final long serialVersionUID = 1L;
    protected static HashMap<Byte, Class<? extends PeerLocator>> magicMap = new HashMap();

    public static PeerLocator deserialize(ByteBuffer bb) {
        PeerLocator locator;
        Constructor<? extends PeerLocator> constructor;
        byte magic = bb.get();
        Class<? extends PeerLocator> clazz = magicMap.get(magic);
        if (clazz == null) {
            return null;
        }
        Class[] types = new Class[]{ByteBuffer.class};
        try {
            constructor = clazz.getConstructor(types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        Object[] args = new Object[]{bb};
        try {
            locator = constructor.newInstance(args);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return locator;
    }

    public abstract void serialize(ByteBuffer var1);

    public abstract Transport<? extends PeerLocator> newRawTransport(PeerId var1) throws IOException;

    public boolean sameClass(PeerLocator target) {
        return this.getClass().equals(target.getClass());
    }
}

