/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.dcl;

import java.awt.geom.Point2D;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import org.piax.common.ComparableKey;
import org.piax.common.subspace.GeoCircle;
import org.piax.common.subspace.GeoEllipse;
import org.piax.common.subspace.GeoRectangle;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.Lower;
import org.piax.common.subspace.Near;
import org.piax.common.subspace.Upper;
import org.piax.common.wrapper.Keys;
import org.piax.common.wrapper.StringKey;
import org.piax.common.wrapper.WrappedComparableKey;
import org.piax.gtrans.dcl.DCLFactory;
import org.piax.gtrans.dcl.DCLParseException;

public class BuiltinFuncFactory
implements DCLFactory {
    final String name;
    final List<Object> args = new ArrayList<Object>();

    static <K extends Comparable<?>> Lower<WrappedComparableKey<K>> newLower(boolean inclusive, K point, int k) {
        WrappedComparableKey p = Keys.newWrappedKey(point);
        return new Lower(inclusive, (ComparableKey)p, k);
    }

    static <K extends Comparable<?>> Upper<WrappedComparableKey<K>> newUpper(boolean inclusive, K point, int k) {
        WrappedComparableKey p = Keys.newWrappedKey(point);
        return new Upper(inclusive, (ComparableKey)p, k);
    }

    BuiltinFuncFactory(String name) {
        this.name = name;
    }

    @Override
    public void add(Object element) {
        this.args.add(element);
    }

    @Override
    public Object getDstCond() {
        if (this.name.equals("date")) {
            if (this.args.size() != 1) {
                throw new DCLParseException("date has one argument");
            }
            try {
                return DateFormat.getDateInstance().parse((String)this.args.get(0));
            }
            catch (ClassCastException e) {
                throw new DCLParseException("date's argument is String");
            }
            catch (Exception e) {
                throw new DCLParseException(e);
            }
        }
        if (this.name.equals("point")) {
            if (this.args.size() != 2) {
                throw new DCLParseException("point has 2 arguments");
            }
            try {
                double x = ((Number)this.args.get(0)).doubleValue();
                double y = ((Number)this.args.get(1)).doubleValue();
                return new Point2D.Double(x, y);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("point's arguments is double");
            }
        }
        if (this.name.equals("rect")) {
            try {
                if (this.args.size() == 4) {
                    double x = ((Number)this.args.get(0)).doubleValue();
                    double y = ((Number)this.args.get(1)).doubleValue();
                    double w = ((Number)this.args.get(2)).doubleValue();
                    double h = ((Number)this.args.get(3)).doubleValue();
                    return new GeoRectangle(x, y, w, h);
                }
                if (this.args.size() == 3) {
                    Point2D p = (Point2D)this.args.get(0);
                    double w = ((Number)this.args.get(1)).doubleValue();
                    double h = ((Number)this.args.get(2)).doubleValue();
                    return new GeoRectangle(p, w, h);
                }
                throw new DCLParseException("rect has 3 or 4 arguments");
            }
            catch (ClassCastException e) {
                throw new DCLParseException("rect's arguments are Point2D or double");
            }
        }
        if (this.name.equals("ellipse")) {
            try {
                if (this.args.size() == 4) {
                    double x = ((Number)this.args.get(0)).doubleValue();
                    double y = ((Number)this.args.get(1)).doubleValue();
                    double w = ((Number)this.args.get(2)).doubleValue();
                    double h = ((Number)this.args.get(3)).doubleValue();
                    return new GeoEllipse(x, y, w, h);
                }
                if (this.args.size() == 3) {
                    Point2D p = (Point2D)this.args.get(0);
                    double w = ((Number)this.args.get(1)).doubleValue();
                    double h = ((Number)this.args.get(2)).doubleValue();
                    return new GeoEllipse(p, w, h);
                }
                throw new DCLParseException("ellipse has 3 or 4 arguments");
            }
            catch (ClassCastException e) {
                throw new DCLParseException("ellipse's arguments are Point2D or double");
            }
        }
        if (this.name.equals("circle")) {
            try {
                if (this.args.size() == 3) {
                    double x = ((Number)this.args.get(0)).doubleValue();
                    double y = ((Number)this.args.get(1)).doubleValue();
                    double r = ((Number)this.args.get(2)).doubleValue();
                    return new GeoCircle(x, y, r);
                }
                if (this.args.size() == 2) {
                    Point2D p = (Point2D)this.args.get(0);
                    double r = ((Number)this.args.get(1)).doubleValue();
                    return new GeoCircle(p, r);
                }
                throw new DCLParseException("circle has 2 or 3 arguments");
            }
            catch (ClassCastException e) {
                throw new DCLParseException("circle's arguments are Point2D or double");
            }
        }
        if (this.name.equals("near")) {
            try {
                if (this.args.size() == 3) {
                    double x = ((Number)this.args.get(0)).doubleValue();
                    double y = ((Number)this.args.get(1)).doubleValue();
                    int k = ((Number)this.args.get(2)).intValue();
                    return new Near(x, y, k);
                }
                if (this.args.size() == 2) {
                    Point2D p = (Point2D)this.args.get(0);
                    int k = ((Number)this.args.get(1)).intValue();
                    return new Near(p, k);
                }
                throw new DCLParseException("near has 2 or 3 arguments");
            }
            catch (ClassCastException e) {
                throw new DCLParseException("near's arguments are Point2D or int");
            }
        }
        if (this.name.equals("maxLower")) {
            if (this.args.size() != 1) {
                throw new DCLParseException("maxLower has one argument");
            }
            try {
                return BuiltinFuncFactory.newLower(true, (Comparable)this.args.get(0), 1);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("maxLower's argument is Comparable");
            }
        }
        if (this.name.equals("lower")) {
            if (this.args.size() != 2) {
                throw new DCLParseException("lower has 2 arguments");
            }
            try {
                int k = ((Number)this.args.get(1)).intValue();
                return BuiltinFuncFactory.newLower(true, (Comparable)this.args.get(0), k);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("lower's arguments are Comparable or int");
            }
        }
        if (this.name.equals("lowerThan")) {
            if (this.args.size() != 2) {
                throw new DCLParseException("lowerThan has 2 arguments");
            }
            try {
                int k = ((Number)this.args.get(1)).intValue();
                return BuiltinFuncFactory.newLower(false, (Comparable)this.args.get(0), k);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("lowerThan's arguments are Comparable or int");
            }
        }
        if (this.name.equals("minUpper")) {
            if (this.args.size() != 1) {
                throw new DCLParseException("minUpper has one argument");
            }
            try {
                return BuiltinFuncFactory.newUpper(true, (Comparable)this.args.get(0), 1);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("minUpper's argument is Comparable");
            }
        }
        if (this.name.equals("upper")) {
            if (this.args.size() != 2) {
                throw new DCLParseException("upper has 2 arguments");
            }
            try {
                int k = ((Number)this.args.get(1)).intValue();
                return BuiltinFuncFactory.newUpper(true, (Comparable)this.args.get(0), k);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("upper's arguments are Comparable or int");
            }
        }
        if (this.name.equals("upperThan")) {
            if (this.args.size() != 2) {
                throw new DCLParseException("upperThan has 2 arguments");
            }
            try {
                int k = ((Number)this.args.get(1)).intValue();
                return BuiltinFuncFactory.newUpper(false, (Comparable)this.args.get(0), k);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("upperThan's arguments are Comparable or int");
            }
        }
        if (this.name.equals("prefix")) {
            if (this.args.size() != 1) {
                throw new DCLParseException("prefix has one argument");
            }
            try {
                String s = (String)this.args.get(0);
                StringKey start = new StringKey(s);
                int n = s.length() - 1;
                char c = (char)(s.charAt(n) + '\u0001');
                StringKey end = new StringKey(String.valueOf(s.substring(0, n)) + c);
                return new KeyRange((ComparableKey)start, true, (ComparableKey)end, false);
            }
            catch (ClassCastException e) {
                throw new DCLParseException("prefix's argument is String");
            }
        }
        throw new DCLParseException("func/constant \"" + this.name + "\" is not supported");
    }
}

