/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.dcl;

import java.util.ArrayList;
import java.util.List;
import org.piax.common.Destination;
import org.piax.gtrans.dcl.VarDestinationPair;
import org.piax.gtrans.dcl.parser.ParseException;

public class DestinationCondition
implements Destination {
    private static final long serialVersionUID = 1L;
    final List<VarDestinationPair> ands;

    DestinationCondition(List<VarDestinationPair> ands) {
        this.ands = ands;
    }

    public synchronized Destination getPredicate() throws ParseException {
        if (this.ands.size() != 1) {
            throw new ParseException("destination should be single predicate");
        }
        VarDestinationPair pair = this.getFirst();
        if (!"_".equals(pair.var)) {
            throw new ParseException("var name should be \"_\"");
        }
        return pair.destination;
    }

    public synchronized VarDestinationPair getFirst() {
        if (this.ands.size() == 0) {
            return null;
        }
        return this.ands.get(0);
    }

    public synchronized List<VarDestinationPair> getSeconds() {
        if (this.ands.size() == 0) {
            return null;
        }
        return new ArrayList<VarDestinationPair>(this.ands.subList(1, this.ands.size()));
    }

    public String toString() {
        return this.ands.toString();
    }
}

