/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.dcl;

import org.piax.common.ComparableKey;
import org.piax.common.subspace.KeyRange;
import org.piax.common.wrapper.Keys;
import org.piax.gtrans.dcl.DCLFactory;
import org.piax.gtrans.dcl.DCLParseException;
import org.piax.util.KeyComparator;

public class IntervalFactory
implements DCLFactory {
    final boolean fromInclusive;
    final boolean toInclusive;
    ComparableKey<?> from = null;
    ComparableKey<?> to = null;
    boolean isFrom = true;

    IntervalFactory(String op) {
        this.fromInclusive = op.charAt(0) == '[';
        this.toInclusive = op.charAt(1) == ']';
    }

    ComparableKey<?> convert(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ComparableKey) {
            return (ComparableKey)element;
        }
        if (element instanceof Comparable) {
            return Keys.newWrappedKey((Comparable)((Comparable)element));
        }
        throw new DCLParseException(String.valueOf(element.getClass().getSimpleName()) + ": interval params should be Comparable");
    }

    @Override
    public void add(Object element) {
        if (element == null) {
            this.isFrom = false;
            return;
        }
        if (this.isFrom) {
            this.from = this.convert(element);
        } else {
            this.to = this.convert(element);
        }
    }

    @Override
    public Object getDstCond() {
        if (this.from == null) {
            this.from = KeyComparator.getMinusInfinity(this.to.getClass());
        }
        if (this.to == null) {
            this.to = KeyComparator.getPlusInfinity(this.from.getClass());
        }
        try {
            return new KeyRange(this.from, this.fromInclusive, this.to, this.toInclusive);
        }
        catch (IllegalArgumentException e) {
            throw new DCLParseException(e);
        }
    }
}

