/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.piax.common.Endpoint;
import org.piax.common.Option;
import org.piax.common.TransportId;
import org.piax.common.TransportIdPath;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.ConfigurationError;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.BaseTransportGenerator;
import org.piax.gtrans.impl.LinkStatAndScoreIf;
import org.piax.gtrans.impl.LocatorStatusObserver;

public class BaseTransportMgr
implements LocatorStatusObserver {
    public static Option.StringOption BASE_TRANSPORT_MANAGER_CLASS = new Option.StringOption("org.piax.gtrans.netty.NettyBaseTransportGenerator", "-base-trans-mgr-class");
    public static LinkStatAndScoreIf statAndScore = null;
    private final List<Transport<?>> baseTransList = new ArrayList();
    final Peer peer;
    BaseTransportGenerator baseTransGen;
    private volatile Transport<?> recentlyUsedTransport;
    private final Set<LocatorStatusObserver> observers = new CopyOnWriteArraySet<LocatorStatusObserver>();

    public BaseTransportMgr(Peer peer) {
        this.peer = peer;
        try {
            Class<?> clazz = Class.forName((String)BASE_TRANSPORT_MANAGER_CLASS.value());
            this.baseTransGen = (BaseTransportGenerator)clazz.getConstructor(Peer.class).newInstance(peer);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fin() {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            for (Transport<?> bt : this.baseTransList) {
                bt.fin();
            }
        }
    }

    public synchronized void addBaseTransportGenerator(BaseTransportGenerator generator) {
        this.baseTransGen.addLast(generator);
    }

    public synchronized void addFirstBaseTransportGenerator(BaseTransportGenerator generator) {
        BaseTransportGenerator prev = this.baseTransGen;
        this.baseTransGen = generator;
        this.baseTransGen.addNext(prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMatchedBaseTransport(PeerLocator target) {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            Transport<?> bt;
            Iterator<Transport<?>> iterator = this.baseTransList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(bt = iterator.next()).getEndpoint().equals(target));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Endpoint> Transport<E> newBaseTransport(String desc, TransportId transId, E myLocator) throws IOException, IdConflictException {
        if (myLocator == null) {
            throw new IllegalArgumentException("me should not be null");
        }
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            if (this.getRelatedBaseTransport(myLocator) != null) {
                throw new IOException("this locator is already used:" + myLocator);
            }
            Transport<E> bt = this.baseTransGen.newBaseTransport(desc, transId, myLocator);
            this.baseTransList.add(0, bt);
            this.onEnabled(myLocator, true);
            return bt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Endpoint> ChannelTransport<E> newBaseChannelTransport(String desc, TransportId transId, E myLocator) throws IOException, IdConflictException {
        if (myLocator == null) {
            throw new IllegalArgumentException("The endpopint is not specified.");
        }
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            if (this.getRelatedBaseTransport(myLocator) != null) {
                throw new IOException("this locator is already used:" + myLocator);
            }
            ChannelTransport<E> bt = this.baseTransGen.newBaseChannelTransport(desc, transId, myLocator);
            this.baseTransList.add(0, bt);
            this.onEnabled(myLocator, true);
            return bt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transport<?>> getBaseTransports() {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            return new ArrayList(this.baseTransList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransportIdPath> getBaseTransportIdPaths() {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            ArrayList<TransportIdPath> paths = new ArrayList<TransportIdPath>();
            for (Transport<?> bt : this.baseTransList) {
                paths.add(bt.getTransportIdPath());
            }
            return paths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Endpoint> Transport<E> removeBaseTransport(E ep) {
        Transport<?> match = null;
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            block5: {
                for (Transport<?> bt : this.baseTransList) {
                    if (!bt.getEndpoint().equals(ep)) continue;
                    match = bt;
                    break;
                }
                if (match != null) break block5;
                return null;
            }
            match.fin();
            this.baseTransList.remove(match);
            return match;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBaseTransports() {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            for (Transport<?> bt : this.baseTransList) {
                bt.fin();
            }
            this.baseTransList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerLocator> getAvailableLocators() {
        ArrayList<PeerLocator> locs = new ArrayList<PeerLocator>();
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            for (Transport<?> bt : this.baseTransList) {
                if (!bt.isUp()) continue;
                locs.add((PeerLocator)bt.getEndpoint());
            }
        }
        return locs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Endpoint> Transport<E> getRelatedBaseTransport(E localLocator) {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            for (Transport<?> bt : this.baseTransList) {
                if (!bt.getEndpoint().equals(localLocator)) continue;
                return bt;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends PeerLocator> Transport<E> getApplicableBaseTransport(E target) {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            for (Transport<?> bt : this.baseTransList) {
                if (!bt.isUp() || !((PeerLocator)bt.getEndpoint()).sameClass(target)) continue;
                this.recentlyUsedTransport = bt;
                return bt;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport<?> getRecentlyUsedTransport() {
        List<Transport<?>> list = this.baseTransList;
        synchronized (list) {
            if (this.recentlyUsedTransport != null && this.recentlyUsedTransport.isUp()) {
                return this.recentlyUsedTransport;
            }
            for (Transport<?> bt : this.baseTransList) {
                if (!bt.isUp()) continue;
                return bt;
            }
            return null;
        }
    }

    private int score(PeerLocator src, PeerLocator dst) {
        if (statAndScore == null) {
            return 0;
        }
        Integer[] e = statAndScore.eval(src, dst);
        return e[e.length - 1];
    }

    public List<ConnectionStat> getConnections(Collection<? extends PeerLocator> remoteLocs) {
        ArrayList<ConnectionStat> conns = new ArrayList<ConnectionStat>();
        for (PeerLocator peerLocator : remoteLocs) {
            int score;
            String stat;
            Transport<PeerLocator> bt = this.getApplicableBaseTransport(peerLocator);
            if (bt == null) continue;
            if (statAndScore == null) {
                stat = "";
                score = 0;
            } else {
                Object[] e = statAndScore.eval((PeerLocator)bt.getEndpoint(), peerLocator);
                stat = String.format(statAndScore.evalFormat(), e);
                score = (Integer)e[e.length - 1];
            }
            conns.add(new ConnectionStat((PeerLocator)bt.getEndpoint(), peerLocator, stat, score));
        }
        return conns;
    }

    public PeerLocator bestRemoteLocator(Collection<? extends PeerLocator> remoteLocs) {
        PeerLocator best = null;
        int bestScore = -1;
        for (PeerLocator peerLocator : remoteLocs) {
            int score;
            Transport<PeerLocator> bt = this.getApplicableBaseTransport(peerLocator);
            if (bt == null || (score = this.score((PeerLocator)bt.getEndpoint(), peerLocator)) <= bestScore) continue;
            bestScore = score;
            best = peerLocator;
        }
        return best;
    }

    public void registerObserver(LocatorStatusObserver observer) {
        this.observers.add(observer);
    }

    public void unregisterObserver(LocatorStatusObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void onEnabled(Endpoint loc, boolean isNew) {
        for (LocatorStatusObserver ob : this.observers) {
            ob.onEnabled(loc, isNew);
        }
    }

    @Override
    public void onFadeout(Endpoint loc, boolean isFin) {
        if (isFin) {
            this.removeBaseTransport(loc);
        }
        for (LocatorStatusObserver ob : this.observers) {
            ob.onFadeout(loc, isFin);
        }
    }

    @Override
    public void onChanging(PeerLocator oldLoc, PeerLocator newLoc) {
        for (LocatorStatusObserver ob : this.observers) {
            ob.onChanging(oldLoc, newLoc);
        }
    }

    @Override
    public void onHangup(PeerLocator loc, Exception cause) {
        this.removeBaseTransport(loc);
        for (LocatorStatusObserver ob : this.observers) {
            ob.onHangup(loc, cause);
        }
    }

    public String toString() {
        return "BaseTransportMgr{baseTrans=" + this.getBaseTransports() + ", recentlyUsedTransport=" + this.recentlyUsedTransport + "}";
    }

    public static class ConnectionStat {
        public final PeerLocator src;
        public final PeerLocator dst;
        public final String stat;
        public final int score;

        public ConnectionStat(PeerLocator src, PeerLocator dst, String stat, int score) {
            this.src = src;
            this.dst = dst;
            this.stat = stat;
            this.score = score;
        }
    }
}

