/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.NetworkTimeoutException;

public abstract class ChannelImpl<E extends Endpoint>
implements Channel<E> {
    private static final Object END_OF_MESSAGE = new Object();
    private static final Object NULL_MESSAGE = new Object();
    protected final PeerId creator;
    protected final ChannelTransport<E> mother;
    protected final ObjectId localObjectId;
    protected final ObjectId remoteObjectId;
    protected final E remote;
    protected final boolean isDuplex;
    private int channelNo;
    private final BlockingQueue<Object> rcvQueue;
    private volatile boolean isActive = true;

    ChannelImpl(ChannelTransport<E> mother, ObjectId localObjectId, ObjectId remoteObjectId, E remote) {
        this(null, mother, localObjectId, remoteObjectId, remote, true);
    }

    ChannelImpl(ChannelTransport<E> mother, ObjectId localObjectId, ObjectId remoteObjectId, E remote, boolean isDuplex) {
        this(null, mother, localObjectId, remoteObjectId, remote, isDuplex);
    }

    ChannelImpl(PeerId creater, ChannelTransport<E> mother, ObjectId localObjectId, ObjectId remoteObjectId, E remote) {
        this(creater, mother, localObjectId, remoteObjectId, remote, true);
    }

    ChannelImpl(PeerId creator, ChannelTransport<E> mother, ObjectId localObjectId, ObjectId remoteObjectId, E remote, boolean isDuplex) {
        this.creator = creator;
        this.localObjectId = localObjectId;
        this.remoteObjectId = remoteObjectId;
        this.mother = mother;
        this.remote = remote;
        this.isDuplex = !mother.supportsDuplex() ? false : isDuplex;
        this.rcvQueue = new LinkedBlockingQueue<Object>();
    }

    @Override
    public void close() {
        this.isActive = false;
        try {
            this.rcvQueue.clear();
            this.rcvQueue.put(END_OF_MESSAGE);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isActive;
    }

    protected void checkActive() throws IllegalStateException {
        if (!this.isActive) {
            throw new IllegalStateException("this channel " + this.mother.getTransportId() + "(" + this.channelNo + ")" + " is already closed");
        }
    }

    @Override
    public TransportId getTransportId() {
        return this.mother.getTransportId();
    }

    void setChannelNo(int channelNo) {
        this.checkActive();
        this.channelNo = channelNo;
    }

    @Override
    public int getChannelNo() {
        return this.channelNo;
    }

    @Override
    public E getLocal() {
        return this.mother.getEndpoint();
    }

    @Override
    public ObjectId getLocalObjectId() {
        return this.localObjectId;
    }

    @Override
    public E getRemote() {
        return this.remote;
    }

    @Override
    public ObjectId getRemoteObjectId() {
        return this.remoteObjectId;
    }

    @Override
    public boolean isDuplex() {
        return this.isDuplex;
    }

    @Override
    public boolean isCreatorSide() {
        return this.creator == null;
    }

    protected void putReceiveQueue(Object msg) {
        try {
            if (msg == null) {
                this.rcvQueue.put(NULL_MESSAGE);
            } else {
                this.rcvQueue.put(msg);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Object receive() {
        try {
            return this.receive(0);
        }
        catch (NetworkTimeoutException ignore) {
            return null;
        }
    }

    @Override
    public Object receive(int timeout) throws NetworkTimeoutException {
        Object msg;
        block6: {
            block5: {
                try {
                    msg = this.rcvQueue.poll(timeout, TimeUnit.MILLISECONDS);
                    if (msg != END_OF_MESSAGE) break block5;
                    return null;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            if (msg != NULL_MESSAGE) break block6;
            return null;
        }
        if (msg == null) {
            throw new NetworkTimeoutException("ch.receive timed out");
        }
        return msg;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{channelNo=" + this.channelNo + ", creator=" + this.creator + ", local=" + this.getLocal() + ", localObjectId=" + this.localObjectId + ", remote=" + this.remote + ", remoteObjectId=" + this.remoteObjectId + "}";
    }
}

