/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.ChannelListener;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelTransportImpl<E extends Endpoint>
extends TransportImpl<E>
implements ChannelTransport<E> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelTransportImpl.class);
    protected final boolean supportsDuplex;
    protected final Map<ObjectId, ChannelListener<E>> chListenersByUpper = new ConcurrentHashMap<ObjectId, ChannelListener<E>>();

    protected ChannelTransportImpl(Peer peer, TransportId transId, Transport<?> lowerTrans, boolean supportsDuplex) throws IdConflictException {
        super(peer, transId, lowerTrans);
        this.supportsDuplex = supportsDuplex;
    }

    protected ChannelTransportImpl(Peer peer, boolean supportsDuplex) {
        super(peer);
        this.supportsDuplex = supportsDuplex;
    }

    @Override
    public void fin() {
        super.fin();
        this.chListenersByUpper.clear();
    }

    @Override
    public boolean supportsDuplex() {
        return this.supportsDuplex;
    }

    @Override
    public void setChannelListener(ObjectId upper, ChannelListener<E> listener) {
        logger.trace("ENTRY:");
        logger.debug("transId {}", (Object)this.transId);
        logger.debug("receiver {}", (Object)upper);
        if (listener == null) {
            this.chListenersByUpper.remove(upper);
        } else {
            this.checkActive();
            this.chListenersByUpper.put(upper, listener);
        }
    }

    @Override
    public ChannelListener<E> getChannelListener(ObjectId upper) {
        return this.chListenersByUpper.get(upper);
    }

    @Override
    public void setChannelListener(ChannelListener<E> listener) {
        this.setChannelListener(this.getDefaultAppId(), listener);
    }

    @Override
    public ChannelListener<E> getChannelListener() {
        return this.getChannelListener(this.getDefaultAppId());
    }

    @Override
    public Channel<E> newChannel(ObjectId sender, ObjectId receiver, E dst) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(sender, receiver, dst, true, GTransConfigValues.newChannelTimeout);
    }

    @Override
    public Channel<E> newChannel(ObjectId sender, ObjectId receiver, E dst, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(sender, receiver, dst, true, timeout);
    }

    @Override
    public Channel<E> newChannel(ObjectId sender, ObjectId receiver, E dst, boolean isDuplex) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(sender, receiver, dst, isDuplex, GTransConfigValues.newChannelTimeout);
    }

    @Override
    public Channel<E> newChannel(ObjectId appId, E dst) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(appId, appId, dst);
    }

    @Override
    public Channel<E> newChannel(E dst) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(this.getDefaultAppId(), dst);
    }

    @Override
    public Channel<E> newChannel(ObjectId appId, E dst, boolean isDuplex) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(appId, appId, dst, isDuplex);
    }

    @Override
    public Channel<E> newChannel(E dst, boolean isDuplex) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(this.getDefaultAppId(), dst, isDuplex);
    }

    @Override
    public Channel<E> newChannel(ObjectId appId, E dst, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(appId, appId, dst, true, opts);
    }

    @Override
    public Channel<E> newChannel(E dst, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(this.getDefaultAppId(), this.getDefaultAppId(), dst, true, opts);
    }

    @Override
    public Channel<E> newChannel(ObjectId sender, ObjectId receiver, E dst, boolean isDuplex, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(sender, receiver, dst, isDuplex, (int)TransOptions.timeout((TransOptions)opts));
    }

    @Override
    public abstract Channel<E> newChannel(ObjectId var1, ObjectId var2, E var3, boolean var4, int var5) throws ProtocolUnsupportedException, IOException;

    @Override
    public Channel<E> newChannel(TransportId upperTrans, E dst) throws ProtocolUnsupportedException, IOException {
        return this.newChannel((ObjectId)upperTrans, (ObjectId)upperTrans, dst);
    }

    @Override
    public Channel<E> newChannel(TransportId upperTrans, E dst, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.newChannel((ObjectId)upperTrans, (ObjectId)upperTrans, dst, timeout);
    }

    @Override
    public Channel<E> newChannel(TransportId upperTrans, E dst, boolean isDuplex) throws ProtocolUnsupportedException, IOException {
        return this.newChannel((ObjectId)upperTrans, (ObjectId)upperTrans, dst, isDuplex);
    }

    @Override
    public Channel<E> newChannel(TransportId upperTrans, E dst, boolean isDuplex, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.newChannel((ObjectId)upperTrans, (ObjectId)upperTrans, dst, isDuplex, timeout);
    }

    @Override
    public Channel<E> newChannel(TransportId upperTrans, E dst, boolean isDuplex, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.newChannel((ObjectId)upperTrans, (ObjectId)upperTrans, dst, isDuplex, opts);
    }

    @Override
    public String toString0() {
        return String.valueOf(super.toString0()) + ", chListeners=" + this.chListenersByUpper.keySet();
    }
}

