/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.gtrans.impl.InvalidMessageException;
import org.piax.gtrans.impl.NotEnoughMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NestedMessage.class);
    public static final short PIAX_MAGIC = -275;
    public static final byte isMsgBody = 0;
    public static final byte isNested = 1;
    public static int initialBufSize = 32000;
    public final ObjectId sender;
    public final ObjectId receiver;
    public final PeerId srcPeerId;
    public final Endpoint src;
    public final int channelNo;
    public final Object option;
    public final Object inner;
    public Object passthrough;

    public static int checkAndGetMessageLen(ByteBuffer bbuf) throws NotEnoughMessageException, InvalidMessageException {
        int len = bbuf.remaining();
        if (len < 6) {
            throw new NotEnoughMessageException("data is not enouth: current size=" + len);
        }
        short magic = bbuf.getShort(bbuf.position());
        if (magic != -275) {
            throw new InvalidMessageException("invalid PIAX magic");
        }
        return bbuf.getInt(bbuf.position() + 2);
    }

    public NestedMessage(ObjectId sender, ObjectId receiver, PeerId srcPeerId, Endpoint src, Object inner) {
        this(sender, receiver, srcPeerId, src, 0, null, inner);
    }

    public NestedMessage(ObjectId sender, ObjectId receiver, PeerId srcPeerId, Endpoint src, int channelNo, Object option, Object inner) {
        this.sender = sender;
        this.receiver = receiver;
        this.srcPeerId = srcPeerId;
        this.src = src;
        this.channelNo = channelNo;
        this.option = option;
        this.inner = inner;
        if (inner instanceof NestedMessage) {
            NestedMessage _inner = (NestedMessage)inner;
            this.passthrough = _inner.passthrough;
            _inner.passthrough = null;
        }
    }

    public NestedMessage(NestedMessage nmsg, Object newInner) {
        this(nmsg.sender, nmsg.receiver, nmsg.srcPeerId, nmsg.src, nmsg.channelNo, nmsg.option, newInner);
        this.passthrough = nmsg.passthrough;
    }

    public void setPassthrough(Object obj) {
        this.passthrough = obj;
    }

    public Object getInner() {
        if (this.inner instanceof NestedMessage) {
            NestedMessage _inner = (NestedMessage)this.inner;
            _inner.passthrough = this.passthrough;
        }
        return this.inner;
    }

    public String toString() {
        return "NestedMessage [sender=" + this.sender + ", receiver=" + this.receiver + ", srcPeerId=" + this.srcPeerId + ", src=" + this.src + ", channelNo=" + this.channelNo + ", option=" + this.option + ", passthrough=" + this.passthrough + ", inner=" + this.inner + "]";
    }
}

