/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.util.ArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.gtrans.GTransConfigValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverThreadPool {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverThreadPool.class);
    static int CORE_POOL_SIZE = 10;
    static String THREAD_NAME_PREFIX = "thPool-";
    public static long THREAD_KEEP_ALIVE_TIME = 600000L;
    public static final long MAX_WAIT_TIME_FOR_TERMINATION = 100L;
    private static ThreadPoolExecutor staticThreadPool;
    private static ArrayList<ThreadPoolExecutor> threadPoolList;
    private ThreadPoolExecutor threadPool;
    public static boolean threadPoolByInstance;
    private static int instanceCount;

    static {
        threadPoolList = new ArrayList();
        threadPoolByInstance = false;
        instanceCount = 0;
    }

    public static synchronized int getActiveCount() {
        int n = 0;
        if (threadPoolList.size() > 0) {
            for (ThreadPoolExecutor te : threadPoolList) {
                n += te.getActiveCount();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiverThreadPool() {
        ReceiverThreadPool receiverThreadPool = this;
        synchronized (receiverThreadPool) {
            if (threadPoolByInstance) {
                this.threadPool = new ThreadPoolExecutor(Math.min(CORE_POOL_SIZE, GTransConfigValues.MAX_RECEIVER_THREAD_SIZE), GTransConfigValues.MAX_RECEIVER_THREAD_SIZE, THREAD_KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolFactory(), new ThreadPoolExecutor.AbortPolicy());
                threadPoolList.add(this.threadPool);
            } else {
                if (instanceCount == 0) {
                    staticThreadPool = new ThreadPoolExecutor(Math.min(CORE_POOL_SIZE, GTransConfigValues.MAX_RECEIVER_THREAD_SIZE), GTransConfigValues.MAX_RECEIVER_THREAD_SIZE, THREAD_KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolFactory(), new ThreadPoolExecutor.AbortPolicy());
                    threadPoolList.add(staticThreadPool);
                }
                this.threadPool = staticThreadPool;
            }
            ++instanceCount;
        }
    }

    public void execute(Runnable receiveTask) throws RejectedExecutionException {
        try {
            this.threadPool.execute(receiveTask);
        }
        catch (RejectedExecutionException e) {
            if (this.threadPool.isShutdown()) {
                logger.info("message discarded as threadPool is shutdown");
            }
            throw e;
        }
    }

    public synchronized void fin() {
        --instanceCount;
        if (threadPoolByInstance) {
            this.threadPool.shutdown();
            try {
                this.threadPool.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("some tasks not terminated");
            }
            threadPoolList.remove(this.threadPool);
        } else if (instanceCount == 0) {
            staticThreadPool.shutdown();
            try {
                staticThreadPool.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("some tasks not terminated");
            }
            threadPoolList.remove(staticThreadPool);
        }
    }

    private static class ThreadPoolFactory
    implements ThreadFactory {
        final AtomicInteger thNum = new AtomicInteger(1);

        private ThreadPoolFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.valueOf(THREAD_NAME_PREFIX) + this.thNum.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

