/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.common.Destination;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.TransportIdPath;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportImpl<D extends Destination>
implements Transport<D> {
    private static final Logger logger = LoggerFactory.getLogger(TransportImpl.class);
    protected final Peer peer;
    protected final PeerId peerId;
    protected final TransportId transId;
    protected final Transport<?> lowerTrans;
    protected final List<TransportImpl<?>> uppers = new ArrayList();
    protected final TransportIdPath transIdPath;
    protected ObjectId defaultAppId = null;
    protected volatile boolean isBaseTransport = false;
    protected final Map<ObjectId, TransportListener<D>> listenersByUpper = new ConcurrentHashMap<ObjectId, TransportListener<D>>();
    protected volatile boolean isActive = true;

    public void setDefaultAppId(ObjectId appId) {
        this.defaultAppId = appId;
    }

    public ObjectId getDefaultAppId() {
        return this.defaultAppId == null ? DEFAULT_APP_ID : this.defaultAppId;
    }

    protected TransportImpl(Peer peer, TransportId transId, Transport<?> lowerTrans) throws IdConflictException {
        if (transId == null) {
            throw new IllegalArgumentException("transId should not be null");
        }
        this.peer = peer;
        this.peerId = peer.getPeerId();
        this.transId = transId;
        this.lowerTrans = lowerTrans;
        TransportIdPath lowerIdPath = lowerTrans == null ? null : lowerTrans.getTransportIdPath();
        this.transIdPath = new TransportIdPath(lowerIdPath, transId);
        if (lowerTrans != null && lowerTrans instanceof TransportImpl) {
            ((TransportImpl)lowerTrans).addUpper(this);
        }
        logger.debug("transId:{} path:{}", (Object)transId, (Object)this.transIdPath);
        peer.registerTransport(this.transIdPath, this);
    }

    protected TransportImpl(Peer peer) {
        this.peer = peer;
        this.peerId = peer.getPeerId();
        this.transId = null;
        this.lowerTrans = null;
        this.transIdPath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fin() {
        TransportImpl transportImpl = this;
        synchronized (transportImpl) {
            this.isActive = false;
            this.listenersByUpper.clear();
            if (this.transId != null) {
                this.peer.unregisterTransport(this.transIdPath, this);
            }
            if (this.lowerTrans != null && this.lowerTrans instanceof TransportImpl) {
                ((TransportImpl)this.lowerTrans).removeUpper(this);
            }
        }
    }

    synchronized void addUpper(TransportImpl<?> upper) {
        this.uppers.add(upper);
    }

    synchronized void removeUpper(TransportImpl<?> upper) {
        this.uppers.remove(upper);
    }

    public synchronized List<TransportImpl<?>> getUppers() {
        return new ArrayList(this.uppers);
    }

    protected void checkActive() throws IllegalStateException {
        if (!this.isActive) {
            throw new IllegalStateException("this transport " + this.transId + " is already finalized");
        }
    }

    @Override
    public Peer getPeer() {
        return this.peer;
    }

    @Override
    public PeerId getPeerId() {
        return this.peer.getPeerId();
    }

    @Override
    public TransportId getTransportId() {
        return this.transId;
    }

    @Override
    public TransportIdPath getTransportIdPath() {
        return this.transIdPath;
    }

    @Override
    public int getMTU() {
        return GTransConfigValues.MAX_MSG_SIZE;
    }

    @Override
    public Transport<?> getLowerTransport() {
        return this.lowerTrans;
    }

    @Override
    public List<Transport<?>> getLowerTransports() {
        ArrayList<Transport<?>> trans;
        if (this.lowerTrans == null) {
            trans = new ArrayList();
        } else {
            trans = this.lowerTrans.getLowerTransports();
            if (this.lowerTrans.getTransportId() != null) {
                trans.add(this.lowerTrans);
            }
        }
        return trans;
    }

    public void setBaseTransport() {
        this.isBaseTransport = true;
    }

    @Override
    public Transport<?> getBaseTransport() {
        if (this.isBaseTransport) {
            return this;
        }
        return this.lowerTrans == null ? null : this.lowerTrans.getBaseTransport();
    }

    @Override
    public boolean isUp() {
        if (this.lowerTrans != null) {
            return this.lowerTrans.isUp();
        }
        return true;
    }

    @Override
    public boolean hasStableLocator() {
        if (this.lowerTrans != null) {
            return this.lowerTrans.hasStableLocator();
        }
        return true;
    }

    @Override
    public void setListener(ObjectId upper, TransportListener<D> listener) {
        logger.trace("ENTRY:");
        logger.debug("transId:{}, upper:{}", (Object)this.transId, (Object)upper);
        if (listener == null) {
            this.listenersByUpper.remove(upper);
        } else {
            this.checkActive();
            this.listenersByUpper.put(upper, listener);
        }
    }

    @Override
    public void setListener(TransportListener<D> listener) {
        this.setListener(this.getDefaultAppId(), listener);
    }

    @Override
    public TransportListener<D> getListener(ObjectId upper) {
        return this.listenersByUpper.get(upper);
    }

    @Override
    public TransportListener<D> getListener() {
        return this.listenersByUpper.get(this.getDefaultAppId());
    }

    @Override
    public abstract void send(ObjectId var1, ObjectId var2, D var3, Object var4, TransOptions var5) throws ProtocolUnsupportedException, IOException;

    @Override
    public void send(ObjectId sender, ObjectId receiver, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        this.send(sender, receiver, dst, msg, null);
    }

    @Override
    public void send(D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        this.send(this.getDefaultAppId(), this.getDefaultAppId(), dst, msg, null);
    }

    @Override
    public void send(D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        this.send(this.getDefaultAppId(), this.getDefaultAppId(), dst, msg, opts);
    }

    @Override
    public void send(ObjectId appId, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        this.send(appId, appId, dst, msg, new TransOptions());
    }

    @Override
    public void send(ObjectId appId, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        this.send(appId, appId, dst, msg, opts);
    }

    @Override
    public void send(TransportId upperTrans, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        this.send((ObjectId)upperTrans, (ObjectId)upperTrans, dst, msg, opts);
    }

    @Override
    public void send(TransportId upperTrans, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        this.send((ObjectId)upperTrans, (ObjectId)upperTrans, dst, msg, new TransOptions());
    }

    public String toString0() {
        return String.valueOf(this.getClass().getSimpleName()) + "{peerId=" + this.getPeerId() + ", transIdPath=" + this.transIdPath + ", listeners=" + this.listenersByUpper.keySet();
    }

    public String toString() {
        return String.valueOf(this.toString0()) + "}";
    }
}

