/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.piax.common.ComparableKey;
import org.piax.common.Endpoint;
import org.piax.common.wrapper.DoubleKey;
import org.piax.common.wrapper.IntegerKey;
import org.piax.common.wrapper.StringKey;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.idtrans.PrimaryKey;

public interface NettyEndpoint
extends Endpoint {
    public static final Pattern SPLITTER = Pattern.compile("[^\\\\]:");

    public int getPort();

    public String getHost();

    public String getKeyString();

    public static List<String> parse(String input) {
        ArrayList<String> ret = new ArrayList<String>();
        Matcher m = SPLITTER.matcher(input);
        while (m.find()) {
            ret.add(input.substring(0, m.end() - 1).replace("\\", ""));
            input = input.substring(m.end());
            m = SPLITTER.matcher(input);
        }
        ret.add(input);
        return ret;
    }

    public static ComparableKey<?> parseKey(String input) {
        Object key;
        block3: {
            if (!input.equals("*")) break block3;
            return null;
        }
        try {
            Number number = NumberFormat.getInstance().parse(input);
            int dot = input.indexOf(46);
            key = dot > 0 ? new DoubleKey(Double.valueOf(number.doubleValue())) : new IntegerKey(Integer.valueOf(number.intValue()));
        }
        catch (ParseException e) {
            key = new StringKey(input);
        }
        return key;
    }

    public static NettyEndpoint parsePrimaryKey(String spec) {
        List<String> specs = NettyEndpoint.parse(spec);
        return new PrimaryKey(NettyEndpoint.parseKey(specs.get(1)), new NettyLocator(NettyLocator.parseType(specs.get(2)), specs.get(3), Integer.parseInt(specs.get(4))));
    }

    public static NettyEndpoint parseLocator(String spec) {
        List<String> specs = NettyEndpoint.parse(spec);
        return new NettyLocator(NettyLocator.parseType(specs.get(0)), specs.get(1), Integer.parseInt(specs.get(2)));
    }
}

