/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.piax.common.PeerId;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.Transport;
import org.piax.gtrans.netty.NettyEndpoint;

public class NettyLocator
extends PeerLocator
implements NettyEndpoint {
    TYPE type;
    String host;
    int port;
    public static TYPE DEFAULT_TYPE = TYPE.TCP;
    private static final long serialVersionUID = -2778097890346547201L;

    public NettyLocator() {
    }

    public static NettyLocator parse(String spec) {
        return (NettyLocator)NettyEndpoint.parseLocator(spec);
    }

    public NettyLocator(String type, InetAddress addr, int port) {
        this(NettyLocator.parseType(type), addr, port);
    }

    public NettyLocator(InetAddress addr, int port) {
        this(TYPE.UNKNOWN, addr, port);
    }

    public NettyLocator(InetSocketAddress addr) {
        this(DEFAULT_TYPE, addr.getHostName(), addr.getPort());
    }

    public NettyLocator(TYPE type, InetAddress addr, int port) {
        this.type = type;
        this.host = addr.getHostAddress();
        this.port = port;
    }

    public NettyLocator(TYPE type, int port) {
        this.type = type;
        this.host = null;
        this.port = port;
    }

    public NettyLocator(TYPE type, InetSocketAddress saddr) {
        this(type, saddr.getHostName(), saddr.getPort());
    }

    public NettyLocator(String host, int port) {
        this(DEFAULT_TYPE, host, port);
    }

    public NettyLocator(TYPE type, String host, int port) {
        this.type = type;
        this.host = host;
        this.port = port;
    }

    public static TYPE parseType(String str) {
        TYPE t = str.equals("tcp") ? TYPE.TCP : (str.equals("ssl") ? TYPE.SSL : (str.equals("ws") ? TYPE.WS : (str.equals("wss") ? TYPE.WSS : (str.equals("udt") ? TYPE.UDT : (str.equals("udp") ? TYPE.UDP : TYPE.TCP)))));
        return t;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (o instanceof NettyLocator) {
            NettyLocator l = (NettyLocator)o;
            return (this.host == null || l.host == null || this.host != null && this.host.equals(l.host)) && this.port == l.port;
        }
        return false;
    }

    public TYPE getType() {
        return this.type;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public void serialize(ByteBuffer bb) {
    }

    public Transport<NettyLocator> newRawTransport(PeerId peerId) throws IOException {
        return null;
    }

    @Override
    public String getKeyString() {
        return this.toString();
    }

    public int hashCode() {
        return ((Object)((Object)this.type) + ":" + this.toString()).hashCode();
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + (this.host == null ? "NONE" : this.host) + ":" + this.port;
    }

    public static enum TYPE {
        TCP,
        SSL,
        WS,
        WSS,
        UDT,
        UDP,
        UNKNOWN;

    }
}

