/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import org.piax.common.Option;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.kryo.KryoDecoder;
import org.piax.gtrans.netty.kryo.KryoEncoder;

public abstract class NettyBootstrap<E extends NettyEndpoint> {
    static int NUMBER_OF_THREADS_FOR_CLIENT = 1;
    static int NUMBER_OF_THREADS_FOR_SERVER = 1;
    public static Option.EnumOption<SerializerType> SERIALIZER = new Option.EnumOption(SerializerType.class, (Enum)SerializerType.Kryo, "-serializer");

    public abstract EventLoopGroup getParentEventLoopGroup();

    public abstract EventLoopGroup getChildEventLoopGroup();

    public abstract EventLoopGroup getClientEventLoopGroup();

    public abstract Bootstrap getBootstrap(NettyLocator var1, ChannelInboundHandlerAdapter var2);

    public abstract AbstractBootstrap getServerBootstrap(ChannelInboundHandlerAdapter var1);

    protected void setupSerializers(ChannelPipeline p) {
        switch ((SerializerType)((Object)SERIALIZER.value())) {
            case Kryo: {
                p.addLast(new ChannelHandler[]{new KryoEncoder(), new KryoDecoder()});
                break;
            }
            case Java: {
                p.addLast(new ChannelHandler[]{new ObjectEncoder(), new ObjectDecoder(ClassResolvers.cacheDisabled((ClassLoader)GTransConfigValues.classLoaderForDeserialize))});
            }
        }
    }

    public ChannelFuture connect(Bootstrap b, String host, int port) {
        return b.connect(host, port);
    }

    public static enum SerializerType {
        Java,
        Kryo;

    }
}

