/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.bootstrap.NettyBootstrap;

public class SslBootstrap<E extends NettyEndpoint>
extends NettyBootstrap<E> {
    String host;
    int port;
    EventLoopGroup parentGroup = new NioEventLoopGroup(1);
    EventLoopGroup childGroup = new NioEventLoopGroup(NettyBootstrap.NUMBER_OF_THREADS_FOR_SERVER);
    EventLoopGroup clientGroup = new NioEventLoopGroup(NettyBootstrap.NUMBER_OF_THREADS_FOR_CLIENT);

    public SslBootstrap(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public EventLoopGroup getParentEventLoopGroup() {
        return this.parentGroup;
    }

    @Override
    public EventLoopGroup getChildEventLoopGroup() {
        return this.childGroup;
    }

    @Override
    public EventLoopGroup getClientEventLoopGroup() {
        return this.clientGroup;
    }

    private ChannelInitializer<?> getChannelInboundInitializer(final ChannelInboundHandlerAdapter ihandler) {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                SelfSignedCertificate ssc = null;
                try {
                    ssc = new SelfSignedCertificate();
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                }
                SslContext sslCtx = ssc != null ? SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build() : null;
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                }
                SslBootstrap.this.setupSerializers(p);
                p.addLast(new ChannelHandler[]{ihandler});
            }
        };
    }

    private ChannelInitializer<?> getChannelOutboundInitializer(final NettyLocator raw, final ChannelInboundHandlerAdapter ohandler) {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                SslContext ssl;
                try {
                    ssl = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                }
                catch (SSLException e) {
                    ssl = null;
                }
                SslContext sslCtx = ssl;
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), raw.getHost(), raw.getPort())});
                }
                SslBootstrap.this.setupSerializers(p);
                p.addLast(new ChannelHandler[]{ohandler});
            }
        };
    }

    @Override
    public AbstractBootstrap getServerBootstrap(ChannelInboundHandlerAdapter ihandler) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.parentGroup, this.childGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true);
        ((ServerBootstrap)b.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler(this.getChannelInboundInitializer(ihandler));
        return b;
    }

    @Override
    public Bootstrap getBootstrap(NettyLocator locator, ChannelInboundHandlerAdapter ohandler) {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.clientGroup)).channel(NioSocketChannel.class)).handler(this.getChannelOutboundInitializer(locator, ohandler));
        return b;
    }
}

