/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.bootstrap.NettyBootstrap;

public class TcpBootstrap<E extends NettyEndpoint>
extends NettyBootstrap<E> {
    EventLoopGroup parentGroup = new NioEventLoopGroup(1);
    EventLoopGroup childGroup = new NioEventLoopGroup(NettyBootstrap.NUMBER_OF_THREADS_FOR_SERVER);
    EventLoopGroup clientGroup = new NioEventLoopGroup(NettyBootstrap.NUMBER_OF_THREADS_FOR_CLIENT);

    @Override
    public EventLoopGroup getParentEventLoopGroup() {
        return this.parentGroup;
    }

    @Override
    public EventLoopGroup getChildEventLoopGroup() {
        return this.childGroup;
    }

    @Override
    public EventLoopGroup getClientEventLoopGroup() {
        return this.clientGroup;
    }

    @Override
    public Bootstrap getBootstrap(NettyLocator dst, ChannelInboundHandlerAdapter ohandler) {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.clientGroup)).channel(NioSocketChannel.class)).handler(this.getChannelOutboundInitializer(dst, ohandler));
        return b;
    }

    private ChannelHandler getChannelOutboundInitializer(NettyLocator dst, final ChannelInboundHandlerAdapter ohandler) {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                TcpBootstrap.this.setupSerializers(p);
                p.addLast(new ChannelHandler[]{ohandler});
            }
        };
    }

    public ServerBootstrap getServerBootstrap(ChannelInboundHandlerAdapter ihandler) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.parentGroup, this.childGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true);
        b.childHandler(this.getChannelInboundInitializer(ihandler));
        return b;
    }

    private ChannelHandler getChannelInboundInitializer(final ChannelInboundHandlerAdapter ihandler) {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                TcpBootstrap.this.setupSerializers(p);
                p.addLast(new ChannelHandler[]{ihandler});
            }
        };
    }
}

