/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.bootstrap.NettyBootstrap;

public class UdtBootstrap<E extends NettyEndpoint>
extends NettyBootstrap<E> {
    EventLoopGroup parentGroup;
    EventLoopGroup childGroup;
    EventLoopGroup clientGroup;

    public UdtBootstrap() {
        DefaultThreadFactory bossFactory = new DefaultThreadFactory("parent");
        DefaultThreadFactory serverFactory = new DefaultThreadFactory("child");
        DefaultThreadFactory clientFactory = new DefaultThreadFactory("client");
        this.parentGroup = new NioEventLoopGroup(1, (ThreadFactory)bossFactory, NioUdtProvider.BYTE_PROVIDER);
        this.childGroup = new NioEventLoopGroup(NettyBootstrap.NUMBER_OF_THREADS_FOR_SERVER, (ThreadFactory)serverFactory, NioUdtProvider.BYTE_PROVIDER);
        this.clientGroup = new NioEventLoopGroup(NettyBootstrap.NUMBER_OF_THREADS_FOR_CLIENT, (ThreadFactory)clientFactory, NioUdtProvider.BYTE_PROVIDER);
    }

    @Override
    public EventLoopGroup getParentEventLoopGroup() {
        return this.parentGroup;
    }

    @Override
    public EventLoopGroup getChildEventLoopGroup() {
        return this.childGroup;
    }

    @Override
    public EventLoopGroup getClientEventLoopGroup() {
        return this.clientGroup;
    }

    @Override
    public Bootstrap getBootstrap(NettyLocator dst, ChannelInboundHandlerAdapter ohandler) {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.clientGroup)).channelFactory(NioUdtProvider.BYTE_CONNECTOR)).handler(this.getChannelOutboundInitializer(dst, ohandler));
        return b;
    }

    private ChannelHandler getChannelOutboundInitializer(NettyLocator dst, final ChannelInboundHandlerAdapter ohandler) {
        return new ChannelInitializer<UdtChannel>(){

            public void initChannel(UdtChannel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                UdtBootstrap.this.setupSerializers(p);
                p.addLast(new ChannelHandler[]{ohandler});
            }
        };
    }

    public ServerBootstrap getServerBootstrap(ChannelInboundHandlerAdapter ihandler) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.parentGroup, this.childGroup).channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, (Object)10)).option(ChannelOption.SO_REUSEADDR, (Object)true);
        ((ServerBootstrap)b.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler(this.getChannelInboundInitializer(ihandler));
        return b;
    }

    private ChannelHandler getChannelInboundInitializer(final ChannelInboundHandlerAdapter ihandler) {
        return new ChannelInitializer<UdtChannel>(){

            public void initChannel(UdtChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                UdtBootstrap.this.setupSerializers(p);
                p.addLast(new ChannelHandler[]{ihandler});
            }
        };
    }
}

