/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.idtrans;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.common.PeerId;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.NettyMessage;
import org.piax.gtrans.netty.idtrans.IdChannelTransport;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorChannel {
    private Channel channel;
    private final NettyLocator remote;
    private final IdChannelTransport trans;
    private static final Logger logger = LoggerFactory.getLogger((String)LocatorChannel.class.getName());
    Integer attempt = null;
    long lastUse;
    PrimaryKey primaryKey;
    AtomicInteger useCount;
    Stat stat;

    public LocatorChannel(IdChannelTransport trans) {
        this.remote = null;
        this.trans = trans;
        this.attempt = null;
        this.stat = Stat.RUN;
        this.channel = null;
        this.useCount = new AtomicInteger(0);
        this.lastUse = System.currentTimeMillis();
    }

    public LocatorChannel(NettyLocator remote, IdChannelTransport trans) {
        this.remote = remote;
        this.trans = trans;
        this.attempt = null;
        this.stat = Stat.INIT;
        this.channel = null;
        this.useCount = new AtomicInteger(0);
        this.lastUse = System.currentTimeMillis();
    }

    public synchronized void setPrimaryKey(PrimaryKey key) {
        logger.debug("set primary key for {} on {} as {}", new Object[]{this.remote, this.trans.getEndpoint(), key});
        this.primaryKey = key;
    }

    public synchronized PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void use() {
        this.useCount.incrementAndGet();
    }

    public synchronized void setNettyChannel(Channel channel) {
        this.channel = channel;
        this.lastUse = System.currentTimeMillis();
    }

    public synchronized Channel getNettyChannel() {
        return this.channel;
    }

    public PeerId getPeerId() {
        return this.trans.getPeerId();
    }

    public void touch() {
        this.lastUse = System.currentTimeMillis();
    }

    public CompletableFuture<Boolean> closeAsync(boolean force) {
        CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
        if (force || this.useCount.getAndDecrement() == 0) {
            this.channel.close().addListener(future -> ret.complete(true));
        } else {
            ret.complete(true);
        }
        return ret;
    }

    public boolean isClosed() {
        return this.getStat() == Stat.DEFUNCT;
    }

    public int getChannelNo() {
        return this.remote.getPort();
    }

    public NettyLocator getRemote() {
        return this.remote;
    }

    public synchronized void setAttempt(int r) {
        this.attempt = r;
    }

    public synchronized Integer getAttempt() {
        return this.attempt;
    }

    public void unsetAttempt() {
        this.attempt = null;
    }

    public synchronized void setStat(Stat stat) {
        this.stat = stat;
    }

    public synchronized Stat getStat() {
        return this.stat;
    }

    public synchronized void setChannel(Channel channel) {
        this.channel = channel;
    }

    public synchronized Channel getChannel() {
        return this.channel;
    }

    public void send(Object msg) throws IOException {
        this.sendAsync(msg).syncUninterruptibly();
    }

    public ChannelFuture sendAsync(Object msg) throws IOException {
        this.touch();
        logger.debug("sending {} from {} to {}", new Object[]{((NettyMessage)msg).getMsg(), this.trans.getEndpoint(), this.remote});
        if (this.stat != Stat.RUN || !this.channel.isOpen()) {
            new IOException("the sending channel is closed.");
        }
        return this.channel.writeAndFlush(msg);
    }

    public static enum Stat {
        INIT,
        WAIT,
        DENIED,
        RUN,
        DEFUNCT;

    }
}

