/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.idtrans;

import java.util.concurrent.ConcurrentHashMap;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorManager {
    ConcurrentHashMap<PrimaryKey, PrimaryKey> map = new ConcurrentHashMap();
    ConcurrentHashMap<PeerLocator, PrimaryKey> reverseMap = new ConcurrentHashMap();
    protected static final Logger logger = LoggerFactory.getLogger((String)LocatorManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryKey updateAndGet(PrimaryKey primaryKey) {
        PrimaryKey got;
        ConcurrentHashMap<Object, PrimaryKey> concurrentHashMap;
        PrimaryKey ret = primaryKey;
        if (primaryKey.getLocator() != null) {
            concurrentHashMap = this.reverseMap;
            synchronized (concurrentHashMap) {
                got = this.reverseMap.get(primaryKey.getLocator());
                if (got == null) {
                    this.reverseMap.put(primaryKey.getLocator(), primaryKey);
                    logger.debug("reverse: key={}, value={}", (Object)primaryKey.getLocator(), (Object)primaryKey);
                } else {
                    logger.debug("got.locator={}, primaryKey.locator={}", (Object)got.getLocator(), (Object)primaryKey.getLocator());
                    if (!got.getLocator().equals(primaryKey.getLocator())) {
                        if (primaryKey.getLocatorVersion() > got.getLocatorVersion()) {
                            this.reverseMap.remove(got.getLocator());
                            this.reverseMap.put(primaryKey.getLocator(), primaryKey);
                            logger.debug("reverse: key={}, value={}", (Object)primaryKey.getLocator(), (Object)primaryKey);
                        } else {
                            ret = got;
                        }
                    }
                }
            }
        }
        if (primaryKey.getRawKey() != null) {
            concurrentHashMap = this.map;
            synchronized (concurrentHashMap) {
                got = this.map.get(primaryKey);
                if (got == null) {
                    logger.debug("new key:" + primaryKey.getRawKey());
                    this.map.put(primaryKey, primaryKey);
                    ret = got = primaryKey;
                } else if (primaryKey.getLocator() != null && primaryKey.getLocatorVersion() > got.getLocatorVersion()) {
                    got.setLocator(primaryKey.getLocator());
                    got.setNeighbors(primaryKey.getNeighbors());
                    logger.debug("replace key: {} -> {}", primaryKey.getRawKey(), (Object)primaryKey.getLocator());
                    this.map.put(primaryKey, got);
                } else {
                    ret = got;
                }
            }
        }
        return ret;
    }

    public int size() {
        return this.map.size();
    }

    public void fin() {
        this.map.clear();
    }

    public String toString() {
        String ret = "";
        for (PrimaryKey p : this.map.values()) {
            ret = String.valueOf(ret) + p + ":" + p.getNeighbors() + "\n";
        }
        return ret;
    }

    public NettyLocator getLocator(PrimaryKey primaryKey) {
        if (primaryKey.getLocator() != null) {
            return primaryKey.getLocator();
        }
        PrimaryKey got = this.map.get(primaryKey);
        return got.getLocator();
    }

    public void updateKey(NettyLocator direct, PrimaryKey primaryKey) {
        this.reverseMap.put(direct, primaryKey);
        logger.debug("reverse: key={}, value={}", (Object)direct, (Object)primaryKey);
        PrimaryKey got = this.map.get(primaryKey);
        if (primaryKey.getLocatorVersion() > got.getLocatorVersion()) {
            got.setLocator(direct);
            got.setNeighbors(primaryKey.getNeighbors());
        }
    }

    public PrimaryKey reverseGet(NettyLocator direct) {
        return this.reverseMap.get(direct);
    }
}

