/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.idtrans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.piax.common.ComparableKey;
import org.piax.common.Endpoint;
import org.piax.common.wrapper.BooleanKey;
import org.piax.common.wrapper.DoubleKey;
import org.piax.common.wrapper.StringKey;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.UnavailableEndpointError;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.util.KeyComparator;

public class PrimaryKey
implements ComparableKey<PrimaryKey>,
NettyEndpoint {
    private static final long serialVersionUID = -8338701357931025730L;
    public static int MAX_NEIGHBORS = 30;
    protected ComparableKey<?> rawKey;
    private static final KeyComparator keyComp = KeyComparator.getInstance();
    protected NettyLocator locator;
    private List<NeighborEntry> neighbors;
    long version;

    public static PrimaryKey parse(String spec) {
        return (PrimaryKey)NettyEndpoint.parsePrimaryKey(spec);
    }

    PrimaryKey cloneForSend() {
        PrimaryKey ret = new PrimaryKey(this.rawKey, this.locator);
        ret.neighbors = this.neighbors.stream().map(e -> {
            e.key.setNeighbors(null);
            return e;
        }).collect(Collectors.toList());
        return ret;
    }

    public PrimaryKey(PeerLocator seed) {
        this.rawKey = null;
        if (seed instanceof NettyLocator) {
            this.locator = (NettyLocator)seed;
        }
        this.version = System.currentTimeMillis();
    }

    public NettyLocator getLocator() {
        return this.locator;
    }

    public void setLocator(NettyLocator locator) {
        this.locator = locator;
    }

    public void addNeighbor(PrimaryKey key) {
        this.neighbors = new ArrayList<NeighborEntry>();
        this.neighbors.add(new NeighborEntry(key));
        this.version = System.currentTimeMillis();
    }

    public void setNeighbors(List<NeighborEntry> eps) {
        this.neighbors = eps;
        this.version = System.currentTimeMillis();
    }

    public List<NeighborEntry> getNeighbors() {
        return this.neighbors;
    }

    public ComparableKey<?> getRawKey() {
        return this.rawKey;
    }

    public void setRawKey(ComparableKey<?> rawKey) {
        this.rawKey = rawKey;
    }

    private NeighborEntry getNeighborEndpointEntry(PrimaryKey key) {
        return this.neighbors.stream().filter(e -> e.key.equals(key)).findFirst().orElse(null);
    }

    public void markNeighborClosed(PrimaryKey key) {
        NeighborEntry e = this.getNeighborEndpointEntry(key);
        e.alive = false;
    }

    public void markNeighborAlive(PrimaryKey key) {
        NeighborEntry e = this.getNeighborEndpointEntry(key);
        e.alive = true;
    }

    public PrimaryKey(ComparableKey<?> key) {
        this.rawKey = key;
        this.locator = null;
        this.neighbors = null;
        this.version = System.currentTimeMillis();
    }

    public PrimaryKey(ComparableKey<?> key, NettyLocator locator) {
        this.rawKey = key;
        this.locator = locator;
        this.neighbors = null;
        this.version = System.currentTimeMillis();
    }

    public PrimaryKey(Comparable<?> o) {
        if (o instanceof String) {
            this.rawKey = new StringKey((String)((Object)o));
        } else if (o instanceof Double) {
            this.rawKey = new DoubleKey((Double)o);
        } else if (o instanceof Boolean) {
            this.rawKey = new BooleanKey((Boolean)o);
        }
        this.version = System.currentTimeMillis();
    }

    public int compareTo(PrimaryKey o) {
        if (this.rawKey == null || o.rawKey == null) {
            return 0;
        }
        return keyComp.compare(this.rawKey, o.rawKey);
    }

    public PrimaryKey newSameTypeEndpoint(String spec) {
        Endpoint ep = Endpoint.newEndpoint((String)spec);
        if (ep instanceof PeerLocator) {
            ep = new PrimaryKey((PeerLocator)ep);
        }
        if (!(ep instanceof PrimaryKey)) {
            throw new UnavailableEndpointError("primary key or locator expected.");
        }
        return (PrimaryKey)ep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.rawKey == null && o instanceof PeerLocator) {
            return this.locator.equals(o);
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this.rawKey == null || ((PrimaryKey)o).rawKey == null) {
            return ((PrimaryKey)o).locator.equals(this.locator);
        }
        return this.rawKey.equals(((PrimaryKey)o).rawKey);
    }

    public String toString() {
        String ret = "";
        ret = this.rawKey == null ? String.valueOf(ret) + "WILDCARD" : String.valueOf(ret) + this.rawKey.toString();
        ret = String.valueOf(ret) + "," + this.locator;
        return ret;
    }

    public int hashCode() {
        return this.rawKey.hashCode();
    }

    @Override
    public int getPort() {
        return this.locator.getPort();
    }

    @Override
    public String getHost() {
        return this.locator.getHost();
    }

    @Override
    public String getKeyString() {
        return this.rawKey.toString();
    }

    public long getLocatorVersion() {
        return this.version;
    }

    public class NeighborEntry
    implements Serializable {
        private static final long serialVersionUID = 8001237385879970460L;
        public PrimaryKey key;
        public boolean visited;
        public boolean alive;

        public NeighborEntry(PrimaryKey key) {
            this.key = key;
            this.visited = false;
            this.alive = true;
        }
    }
}

