/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.piax.common.DdllKey;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.subspace.Range;
import org.piax.common.wrapper.BooleanKey;
import org.piax.common.wrapper.ByteKey;
import org.piax.common.wrapper.DoubleKey;
import org.piax.common.wrapper.IntegerKey;
import org.piax.common.wrapper.LongKey;
import org.piax.common.wrapper.StringKey;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.netty.ControlMessage;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.NettyMessage;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.netty.udp.UdpPrimaryKey;
import org.piax.gtrans.netty.udp.UdpPrimaryKeySerializer;
import org.piax.gtrans.netty.udp.direct.DirectSignaling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)KryoUtil.class.getName());
    static boolean DEBUG = false;
    static ArrayList<RegistrationPair> registrations = new ArrayList();
    static long initialLastRegistered;
    static long lastRegistered;
    private static final ThreadLocal<Long> lasts;
    private static final ThreadLocal<Kryo> kryos;

    static {
        lastRegistered = initialLastRegistered = System.nanoTime();
        lasts = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                logger.trace("initial last registered={} on thread {}", (Object)lastRegistered, (Object)Thread.currentThread());
                return initialLastRegistered;
            }
        };
        kryos = new ThreadLocal<Kryo>(){

            @Override
            protected Kryo initialValue() {
                Kryo kryo = new Kryo();
                kryo.setClassLoader(GTransConfigValues.classLoaderForDeserialize);
                if (DEBUG) {
                    Log.TRACE();
                }
                ((Kryo.DefaultInstantiatorStrategy)kryo.getInstantiatorStrategy()).setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
                kryo.register(ArrayList.class);
                kryo.register(HashSet.class);
                kryo.register(HashMap.class);
                kryo.register(Class.class);
                kryo.register(byte[].class);
                kryo.register(Integer[].class);
                kryo.register(ObjectId.class);
                kryo.register(PeerId.class);
                kryo.register(Range.class);
                kryo.register(TransportId.class);
                kryo.register(DoubleKey.class);
                kryo.register(StringKey.class);
                kryo.register(ByteKey.class);
                kryo.register(IntegerKey.class);
                kryo.register(BooleanKey.class);
                kryo.register(LongKey.class);
                kryo.register(PeerId.SpecialId.class);
                kryo.register(RemoteValue.class);
                kryo.register(DdllKey.class);
                kryo.register(TransOptions.class);
                kryo.register(ControlMessage.class);
                kryo.register(NettyMessage.class);
                kryo.register(NettyEndpoint.class);
                kryo.register(NettyLocator.class);
                kryo.register(NettyLocator.TYPE.class);
                kryo.register(ControlMessage.ControlType.class);
                kryo.register(PrimaryKey.class);
                kryo.register(DirectSignaling.AddressNotification.class);
                kryo.register(NettyLocator[].class);
                kryo.register(UdpPrimaryKey.class, (Serializer)new UdpPrimaryKeySerializer());
                logger.debug("registered basic classes on thread {}", (Object)Thread.currentThread());
                return kryo;
            }
        };
    }

    public static synchronized void register(Class clazz) {
        if (!registrations.contains(clazz)) {
            registrations.add(new RegistrationPair(clazz, null));
            lastRegistered = System.nanoTime();
            logger.trace("last registered={}", (Object)lastRegistered);
        }
    }

    public static synchronized void register(Class clazz, Serializer serializer) {
        if (!registrations.contains(clazz)) {
            registrations.add(new RegistrationPair(clazz, serializer));
            lastRegistered = System.nanoTime();
            logger.trace("last registered={}", (Object)lastRegistered);
        }
    }

    public static synchronized void reRegisterIfModified() {
        if (lasts.get() < lastRegistered) {
            logger.trace("re-register because the registration is modified on thread {}", (Object)Thread.currentThread());
            Kryo kryo = kryos.get();
            for (RegistrationPair p : registrations) {
                if (p.serializer == null) {
                    kryo.register(p.clazz);
                    continue;
                }
                kryo.register(p.clazz, p.serializer);
            }
            lasts.set(lastRegistered);
        } else {
            logger.trace("Not registered because the registration is not modified on thread {}", (Object)Thread.currentThread());
        }
    }

    public static synchronized int getRegistrationId(Class clazz) {
        int ret = -1;
        boolean required = kryos.get().isRegistrationRequired();
        kryos.get().setRegistrationRequired(true);
        ret = kryos.get().getRegistration(clazz).getId();
        kryos.get().setRegistrationRequired(required);
        return ret;
    }

    public static byte[] encode(Object obj, int bufsize, int bufsizeMax) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Output o = new Output(bufsize, bufsizeMax);
        o.setOutputStream((OutputStream)outStream);
        try {
            KryoUtil.reRegisterIfModified();
            kryos.get().writeClassAndObject(o, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        o.flush();
        byte[] outArray = outStream.toByteArray();
        return outArray;
    }

    public static Object decode(byte[] bytes) {
        Input input = new Input(bytes);
        KryoUtil.reRegisterIfModified();
        Object obj = kryos.get().readClassAndObject(input);
        return obj;
    }

    static class RegistrationPair {
        Class clazz;
        Serializer serializer;

        public RegistrationPair(Class clazz, Serializer serializer) {
            this.clazz = clazz;
            this.serializer = serializer;
        }
    }
}

