/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.loctrans;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.piax.gtrans.netty.loctrans.NettyChannelTransport;
import org.piax.gtrans.netty.loctrans.NettyRawChannel;

public class NettyOutboundHandler
extends ChannelInboundHandlerAdapter {
    final NettyChannelTransport trans;
    final NettyRawChannel raw;

    public NettyOutboundHandler(NettyRawChannel raw, NettyChannelTransport trans) {
        this.raw = raw;
        this.trans = trans;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.trans.outboundActive(this.raw, ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.trans.getPeer().execute(() -> this.trans.outboundReceive(this.raw, ctx, msg));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.trans.outboundInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.trans.outboundInactive(ctx);
    }
}

