/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.loctrans;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.NetworkTimeoutException;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyMessage;
import org.piax.gtrans.netty.loctrans.NettyChannelTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRawChannel<E extends NettyEndpoint>
implements Channel<E> {
    private ChannelHandlerContext ctx;
    private final E remote;
    private final NettyChannelTransport<E> mother;
    private static final Logger logger = LoggerFactory.getLogger((String)NettyRawChannel.class.getName());
    Integer attempt = null;
    long lastUse;
    boolean isCreatorSide;
    int priority;
    Stat stat;

    public NettyRawChannel(NettyChannelTransport<E> mother) {
        this.remote = null;
        this.mother = mother;
        this.attempt = null;
        this.stat = Stat.RUN;
        this.ctx = null;
        this.isCreatorSide = false;
        this.lastUse = System.currentTimeMillis();
        this.priority = 0;
    }

    public NettyRawChannel(E remote, NettyChannelTransport<E> mother) {
        this.remote = remote;
        this.mother = mother;
        this.attempt = null;
        this.stat = Stat.INIT;
        this.ctx = null;
        this.isCreatorSide = false;
        this.lastUse = System.currentTimeMillis();
        this.priority = 0;
    }

    public NettyRawChannel(E remote, NettyChannelTransport<E> mother, boolean isCreatorSide) {
        this.remote = remote;
        this.mother = mother;
        this.attempt = null;
        this.stat = Stat.INIT;
        this.ctx = null;
        this.isCreatorSide = isCreatorSide;
        this.lastUse = System.currentTimeMillis();
        this.priority = 0;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public PeerId getPeerId() {
        return this.mother.getPeerId();
    }

    public void touch() {
        this.lastUse = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConcurrentHashMap concurrentHashMap = this.mother.raws;
        synchronized (concurrentHashMap) {
            this.mother.deleteRaw(this);
            this.setStat(Stat.DEFUNCT);
            this.ctx.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.getStat() == Stat.DEFUNCT;
    }

    @Override
    public TransportId getTransportId() {
        return this.mother.getTransportId();
    }

    @Override
    public int getChannelNo() {
        return this.remote.getPort();
    }

    @Override
    public E getLocal() {
        return (E)this.mother.getEndpoint();
    }

    @Override
    public ObjectId getLocalObjectId() {
        return null;
    }

    @Override
    public E getRemote() {
        return this.remote;
    }

    @Override
    public ObjectId getRemoteObjectId() {
        return null;
    }

    @Override
    public boolean isDuplex() {
        return true;
    }

    @Override
    public boolean isCreatorSide() {
        return this.isCreatorSide;
    }

    public ChannelHandlerContext getContext() {
        return this.ctx;
    }

    public synchronized void setAttempt(int r) {
        this.attempt = r;
    }

    public synchronized Integer getAttempt() {
        return this.attempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttempt() {
        Integer n = this.attempt;
        synchronized (n) {
            this.attempt = null;
        }
    }

    public synchronized void setStat(Stat stat) {
        this.stat = stat;
    }

    public synchronized Stat getStat() {
        return this.stat;
    }

    public synchronized void setContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void send(Object msg) throws IOException {
        this.touch();
        logger.debug("sending {} from {} to {}", new Object[]{((NettyMessage)msg).getMsg(), this.getLocal(), this.getRemote()});
        if (this.stat == Stat.RUN && this.ctx.channel().isOpen()) {
            this.ctx.writeAndFlush(msg);
            logger.debug("sent {} from {} to {}", new Object[]{((NettyMessage)msg).getMsg(), this.getLocal(), this.getRemote()});
        } else {
            new IOException("the sending channel is closed.");
        }
    }

    @Override
    public Object receive() {
        return null;
    }

    @Override
    public Object receive(int timeout) throws NetworkTimeoutException {
        return null;
    }

    public String toString() {
        return "(RAW: stat=" + (Object)((Object)this.getStat()) + " local=" + this.getLocal() + ",remote=" + this.getRemote() + ",lastUse=" + this.lastUse + ")";
    }

    static enum Stat {
        INIT,
        WAIT,
        DENIED,
        RUN,
        DEFUNCT;

    }
}

