/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.udp;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.netty.udp.UdpChannelTransport;
import org.piax.gtrans.netty.udp.UdpLocatorManager;
import org.piax.gtrans.netty.udp.UdpPrimaryKey;
import org.piax.gtrans.netty.udp.UdpRawChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Signaling {
    final ConcurrentHashMap<Integer, Request> pending = new ConcurrentHashMap();
    final ConcurrentHashMap<String, Function<Request, CompletableFuture>> responders = new ConcurrentHashMap();
    static AtomicInteger seq = new AtomicInteger();
    static int SIGNAL_TIMEOUT = 10000;
    protected static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    protected final UdpChannelTransport trans;
    protected static final Logger logger = LoggerFactory.getLogger(Signaling.class);

    public void setResponder(String name, Function<Request, CompletableFuture> f) {
        this.responders.put(name, f);
    }

    protected void post(InetSocketAddress dst, Object obj) {
        this.trans.rawSend(dst, obj);
    }

    protected void post(NettyLocator dst, Object obj) {
        this.trans.rawSend(dst, obj);
    }

    public Signaling(UdpChannelTransport trans) {
        this.trans = trans;
    }

    private void pending(Request req) {
        this.pending.put(req.id, req);
        scheduler.schedule(() -> {
            Request pr = this.pending.get(request.id);
            if (pr != null) {
                request.future.completeExceptionally(new Exception());
                this.pending.remove(request.id);
            }
        }, (long)SIGNAL_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void received(Request req) {
        CompletableFuture f = this.responders.get(req.getClass().getName()).apply(req);
        logger.debug("responder got {}", (Object)req);
        f.whenComplete((ret, e) -> {
            if (e == null) {
                logger.debug("send response to {} from {}", (Object)request.sender, (Object)this.trans.getEndpoint());
                this.post(request.sender, new Response<Object>(request.id, new NettyLocator(NettyLocator.TYPE.UDP, request.sender), this.trans.getEndpoint(), ret));
            }
        });
    }

    public void received(Response resp) {
        Request req = this.pending.get(resp.id);
        if (req != null) {
            req.future.complete(resp);
            this.pending.remove(resp.id);
        }
    }

    public abstract CompletableFuture<UdpRawChannel> doSignaling(PrimaryKey var1, PrimaryKey var2);

    public abstract UdpLocatorManager getLocatorManager();

    public static class Request<T>
    extends SignalingMessage {
        int id = seq.incrementAndGet();
        public transient CompletableFuture<Response<T>> future;
        transient Signaling sig;
        protected transient InetSocketAddress sender;
        public final UdpPrimaryKey senderKey;
        public final NettyLocator dst;
        final boolean requireResponse;

        public String toString() {
            return "[" + this.id + ",senderKey=" + this.senderKey + ",dst=" + (this.dst == null ? "NULL" : this.dst) + ",resp=" + this.requireResponse + "]";
        }

        public Request(Signaling sig, UdpPrimaryKey senderKey, NettyLocator dst) {
            this.future = null;
            this.dst = dst;
            this.sig = sig;
            this.senderKey = senderKey;
            this.sender = null;
            this.requireResponse = false;
        }

        public Request(Signaling sig, UdpPrimaryKey senderKey, NettyLocator dst, BiConsumer<Response<T>, ? super Throwable> consumer) {
            this.future = new CompletableFuture();
            this.future.whenComplete(consumer);
            this.dst = dst;
            this.sig = sig;
            this.senderKey = senderKey;
            this.sender = null;
            this.requireResponse = true;
        }

        public void setSender(InetSocketAddress sender) {
            this.sender = sender;
        }

        public InetSocketAddress getSender() {
            return this.sender;
        }

        public void post() throws SignalingException {
            if (this.requireResponse && this.future != null) {
                this.sig.pending(this);
            }
            try {
                this.sig.post(this.dst, (Object)this);
            }
            catch (Exception e) {
                throw new SignalingException(e);
            }
        }
    }

    public static class Response<T>
    extends SignalingMessage {
        public final int id;
        public final T body;
        public final UdpPrimaryKey senderKey;
        final NettyLocator dst;
        InetSocketAddress sender;

        public Response(int id, NettyLocator dst, UdpPrimaryKey senderKey, T body) {
            this.id = id;
            this.dst = dst;
            this.senderKey = senderKey;
            this.body = body;
        }

        public NettyLocator getDestination() {
            return this.dst;
        }

        public void setSender(InetSocketAddress sender) {
            this.sender = sender;
        }

        public InetSocketAddress getSender() {
            return this.sender;
        }
    }

    public static class SignalingException
    extends Exception {
        public SignalingException(String s) {
            super(s);
        }

        public SignalingException(Exception e) {
            super(e);
        }
    }

    static class SignalingMessage
    implements Serializable {
        SignalingMessage() {
        }
    }
}

