/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.udp;

import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.NetworkTimeoutException;
import org.piax.gtrans.netty.NettyMessage;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.netty.udp.UdpChannelTransport;
import org.piax.gtrans.netty.udp.UdpPrimaryKey;
import org.piax.gtrans.netty.udp.UdpRawChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpIdChannel
implements Channel<UdpPrimaryKey> {
    final ObjectId localObjectId;
    final ObjectId remoteObjectId;
    final UdpPrimaryKey channelInitiator;
    final UdpPrimaryKey dst;
    UdpRawChannel raw;
    final boolean isCreator;
    final UdpChannelTransport trans;
    private final BlockingQueue<Object> rcvQueue;
    final int id;
    boolean isClosed;
    long timestamp;
    private static final Logger logger = LoggerFactory.getLogger((String)UdpIdChannel.class.getName());
    private static final Object EOF = new Object();

    public UdpIdChannel(int channelNo, UdpPrimaryKey channelInitiator, UdpPrimaryKey destination, ObjectId localObjectId, ObjectId remoteObjectId, boolean isCreator, UdpRawChannel raw, UdpChannelTransport udpChannelTransport) {
        this.id = channelNo;
        this.channelInitiator = channelInitiator;
        this.dst = destination;
        this.localObjectId = localObjectId;
        this.remoteObjectId = remoteObjectId;
        this.isCreator = isCreator;
        this.raw = raw;
        this.trans = udpChannelTransport;
        this.isClosed = false;
        this.timestamp = System.currentTimeMillis();
        this.rcvQueue = new LinkedBlockingQueue<Object>();
    }

    static String getKeyString(int id, PrimaryKey key) {
        return "" + id + key.hashCode();
    }

    String getKeyString() {
        return UdpIdChannel.getKeyString(this.id, this.channelInitiator);
    }

    @Override
    public void close() {
        this.raw.close();
    }

    public long elapsedTimeAfterClose() {
        return System.currentTimeMillis() - this.timestamp;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public TransportId getTransportId() {
        return this.trans.getTransportId();
    }

    @Override
    public int getChannelNo() {
        return this.id;
    }

    @Override
    public UdpPrimaryKey getLocal() {
        return this.trans.getEndpoint();
    }

    @Override
    public ObjectId getLocalObjectId() {
        return this.localObjectId;
    }

    @Override
    public UdpPrimaryKey getRemote() {
        return this.dst;
    }

    @Override
    public ObjectId getRemoteObjectId() {
        return this.remoteObjectId;
    }

    @Override
    public boolean isDuplex() {
        return true;
    }

    @Override
    public boolean isCreatorSide() {
        return this.channelInitiator.equals(this.trans.getEndpoint());
    }

    public PrimaryKey getChannelInitiator() {
        return this.channelInitiator;
    }

    @Override
    public void send(Object msg) throws IOException {
        UdpPrimaryKey src = this.trans.getEndpoint();
        NettyMessage<PrimaryKey> nmsg = new NettyMessage<PrimaryKey>(this.remoteObjectId, src, this.dst, this.getChannelInitiator(), this.trans.getPeerId(), msg, true, this.getChannelNo());
        if (!this.raw.isClosed()) {
            logger.debug("ch {}{} send {} from {} to {}", new Object[]{this.getChannelNo(), this.getChannelInitiator(), msg, this.trans.getEndpoint(), this.getRemote()});
        } else {
            logger.debug("locator channel is closed");
        }
        if (this.raw != null) {
            try {
                this.raw.sendAsync(nmsg);
            }
            catch (UdpRawChannel.UdpChannelException e) {
                throw new IOException(e);
            }
        } else {
            logger.debug("locator channel is null");
        }
    }

    public ChannelFuture sendAsync(NettyMessage<UdpPrimaryKey> nmsg) throws Exception {
        if (!this.raw.isClosed()) {
            logger.debug("ch {}{} send {} from {} to {}", new Object[]{this.getChannelNo(), this.getChannelInitiator(), nmsg, this.trans.getEndpoint(), this.getRemote()});
        } else {
            logger.debug("channel for {} is already closed.", nmsg);
        }
        return this.raw.sendAsync(nmsg);
    }

    protected void putReceiveQueue(Object msg) {
        try {
            if (msg == null) {
                this.rcvQueue.put(EOF);
            } else {
                this.rcvQueue.put(msg);
            }
        }
        catch (InterruptedException ignore) {
            ignore.printStackTrace();
        }
    }

    @Override
    public Object receive() {
        Object msg = this.rcvQueue.poll();
        logger.debug("ch {} received {} on {} thread={}", new Object[]{this.getChannelNo(), msg, this.trans.getEndpoint(), Thread.currentThread()});
        if (msg == EOF) {
            logger.debug("ch {} received EOF on {}", new Object[]{this.getChannelNo(), msg, this.trans.getEndpoint()});
            this.isClosed = true;
            return null;
        }
        return msg;
    }

    @Override
    public Object receive(int timeout) throws NetworkTimeoutException {
        Object msg;
        block4: {
            try {
                msg = this.rcvQueue.poll(timeout, TimeUnit.MILLISECONDS);
                logger.debug("ch received {} on {} thread={}", new Object[]{msg, this, Thread.currentThread()});
                if (msg != EOF) break block4;
                logger.debug("ch {} received EOF on {}", new Object[]{this.getChannelNo(), msg, this.trans.getEndpoint()});
                this.isClosed = true;
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        if (msg == null) {
            throw new NetworkTimeoutException("ch.receive timed out");
        }
        return msg;
    }

    public String toString() {
        return String.valueOf(this.getRemote().toString()) + ":" + this.getLocalObjectId() + ":" + this.getChannelNo();
    }
}

