/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.udp;

import java.util.List;
import org.piax.common.ComparableKey;
import org.piax.common.Option;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.netty.NettyEndpoint;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.netty.udp.UdpLocatorManager;

public class UdpPrimaryKey
extends PrimaryKey {
    public static Option.IntegerOption DEFAULT_UDP_PORT = new Option.IntegerOption(12367, "-default-udp-port");
    SIGTYPE sigType;
    NettyLocator[] candidates;
    transient UdpLocatorManager mgr;
    public static Option.EnumOption<SIGTYPE> DEFAULT_SIG_TYPE = new Option.EnumOption(SIGTYPE.class, (Enum)SIGTYPE.DIRECT, "-default-signaling-type");

    public static SIGTYPE parseSigType(String spec) {
        if (spec.equals("udp")) {
            return SIGTYPE.DIRECT;
        }
        if (spec.equals("udpr")) {
            return SIGTYPE.RELAY;
        }
        return (SIGTYPE)((Object)DEFAULT_SIG_TYPE.value());
    }

    public static PrimaryKey parse(String spec) {
        List<String> specs = NettyEndpoint.parse(spec);
        if (specs.size() == 1) {
            return new UdpPrimaryKey(null, (Integer)DEFAULT_UDP_PORT.value());
        }
        if (specs.size() == 2) {
            return new UdpPrimaryKey(NettyEndpoint.parseKey(specs.get(1)), (Integer)DEFAULT_UDP_PORT.value());
        }
        if (specs.size() == 3) {
            return new UdpPrimaryKey(NettyEndpoint.parseKey(specs.get(1)), Integer.parseInt(specs.get(2)));
        }
        if (specs.size() == 4) {
            return new UdpPrimaryKey(NettyEndpoint.parseKey(specs.get(1)), new NettyLocator(NettyLocator.TYPE.UDP, specs.get(2), Integer.parseInt(specs.get(3))));
        }
        return null;
    }

    public void setLocatorManager(UdpLocatorManager mgr) {
        this.mgr = mgr;
    }

    public UdpPrimaryKey(ComparableKey<?> key) {
        this((SIGTYPE)((Object)DEFAULT_SIG_TYPE.value()), key, null);
    }

    public UdpPrimaryKey(NettyLocator locator) {
        this((SIGTYPE)((Object)DEFAULT_SIG_TYPE.value()), null, locator);
    }

    public UdpPrimaryKey(ComparableKey<?> key, NettyLocator locator) {
        this((SIGTYPE)((Object)DEFAULT_SIG_TYPE.value()), key, locator);
    }

    public UdpPrimaryKey(ComparableKey<?> key, int port) {
        this((SIGTYPE)((Object)DEFAULT_SIG_TYPE.value()), key, port);
    }

    public UdpPrimaryKey(SIGTYPE sigType, ComparableKey<?> key, NettyLocator locator) {
        super(key, locator);
        this.sigType = sigType;
    }

    public UdpPrimaryKey(SIGTYPE sigType, ComparableKey<?> key, int port) {
        super(key);
        this.locator = new NettyLocator(NettyLocator.TYPE.UDP, port);
        this.sigType = sigType;
    }

    public UdpPrimaryKey(SIGTYPE sigType, ComparableKey<?> key, NettyLocator locator, NettyLocator[] entries) {
        super(key);
        this.sigType = sigType;
        this.locator = locator;
        this.candidates = entries;
    }

    @Override
    public NettyLocator getLocator() {
        if (this.mgr == null) {
            return this.locator;
        }
        return this.mgr.getPrimaryLocator((Comparable<?>)this.rawKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.rawKey == null && o instanceof PeerLocator) {
            return this.locator.equals(o);
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this.rawKey == null || ((PrimaryKey)o).getRawKey() == null) {
            return ((PrimaryKey)o).getLocator().equals(this.locator);
        }
        return this.rawKey.equals(((PrimaryKey)o).getRawKey());
    }

    public static enum SIGTYPE {
        DIRECT,
        RELAY;

    }
}

