/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.udp.direct;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.piax.common.ComparableKey;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.netty.udp.Signaling;
import org.piax.gtrans.netty.udp.UdpChannelTransport;
import org.piax.gtrans.netty.udp.UdpLocatorManager;
import org.piax.gtrans.netty.udp.UdpPrimaryKey;
import org.piax.gtrans.netty.udp.UdpRawChannel;
import org.piax.gtrans.netty.udp.direct.DirectUdpChannel;
import org.piax.gtrans.netty.udp.direct.KeyLocatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSignaling
extends Signaling {
    protected static final Logger logger = LoggerFactory.getLogger(DirectSignaling.class);
    final KeyLocatorManager klm = new KeyLocatorManager();
    public static long LOCATOR_UPDATE_PERIOD = 60000L;

    @Override
    public UdpLocatorManager getLocatorManager() {
        return this.klm;
    }

    public DirectSignaling(UdpChannelTransport trans) {
        super(trans);
        trans.getEndpoint().setLocatorManager(this.klm);
        this.klm.register((Comparable<?>)trans.getEndpoint().getRawKey(), DirectSignaling.getLocalAddresses(), trans.getEndpoint().getPort(), false);
        this.setResponder(AddressNotification.class.getName(), req -> {
            AddressNotification an = (AddressNotification)req;
            this.klm.register(an.key, an.locs);
            this.klm.registerActive(an.key, req.getSender());
            logger.debug("received request on trans={}", (Object)trans);
            ComparableKey<?> key = trans.getEndpoint().getRawKey();
            logger.debug("key={} dst={}", key, (Object)req.dst);
            this.klm.registerActive((Comparable<?>)key, req.dst);
            return CompletableFuture.completedFuture(this.klm.getLocatorsArray((Comparable<?>)key));
        });
        this.setResponder(KeyRequest.class.getName(), req -> {
            KeyRequest kr = (KeyRequest)req;
            this.klm.registerActive(kr.srcKey, req.getSender());
            if (!kr.dstKey.equals(trans.getEndpoint().getRawKey())) {
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(new Signaling.SignalingException("key not found"));
                return f;
            }
            return CompletableFuture.completedFuture(trans.getEndpoint().getRawKey());
        });
        scheduler.scheduleAtFixedRate(() -> {}, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    static InetAddress[] getLocalAddresses() {
        Enumeration<NetworkInterface> enuIfs = null;
        try {
            enuIfs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        if (enuIfs != null) {
            while (enuIfs.hasMoreElements()) {
                NetworkInterface ni = enuIfs.nextElement();
                Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                while (enuAddrs.hasMoreElements()) {
                    InetAddress addr = enuAddrs.nextElement();
                    addrs.add(addr);
                }
            }
        }
        return addrs.toArray(new InetAddress[0]);
    }

    @Override
    public CompletableFuture<UdpRawChannel> doSignaling(PrimaryKey src, PrimaryKey dst) {
        CompletableFuture<UdpRawChannel> f = new CompletableFuture<UdpRawChannel>();
        NettyLocator dstAddr = null;
        if (dst.getRawKey() != null) {
            KeyLocatorManager.KeyLocatorEntry ent = this.klm.getKeyLocatorEntry((Comparable<?>)dst.getRawKey());
            if (ent == null) {
                dstAddr = dst.getLocator();
            } else {
                KeyLocatorManager.LocatorEntry le = ent.getPrimaryEntry();
                if (le == null) {
                    dstAddr = this.klm.getPrimaryLocator((Comparable<?>)dst.getRawKey());
                } else {
                    if (System.currentTimeMillis() - le.lastAccessed < LOCATOR_UPDATE_PERIOD) {
                        f.complete(new DirectUdpChannel(this.trans, (UdpPrimaryKey)src, new UdpPrimaryKey((ComparableKey)ent.key, le.locator)));
                        return f;
                    }
                    dstAddr = le.locator;
                }
            }
        } else {
            dstAddr = dst.getLocator();
        }
        NettyLocator fAddr = dstAddr;
        AddressNotification req = new AddressNotification(this, this.trans.getEndpoint(), dstAddr, (BiConsumer<Signaling.Response<NettyLocator[]>, ? super Throwable>)((BiConsumer<Signaling.Response<NettyLocator[]>, Throwable>)(resp, ex) -> {
            logger.debug("replied on {}", (Object)this.trans);
            if (ex != null) {
                f.completeExceptionally((Throwable)ex);
            }
            if (resp != null) {
                UdpPrimaryKey key = resp.senderKey;
                key.setLocatorManager(this.klm);
                logger.debug("register active key={} => {} on {}", new Object[]{key.getRawKey(), fAddr, this.trans.getEndpoint()});
                this.klm.register((Comparable<?>)key.getRawKey(), (NettyLocator[])resp.body);
                this.klm.registerActive((Comparable<?>)key.getRawKey(), fAddr);
                this.klm.registerActive((Comparable<?>)this.trans.getEndpoint().getRawKey(), resp.getDestination());
                f.complete(new DirectUdpChannel(this.trans, (UdpPrimaryKey)src, key));
            }
        }), (Comparable<?>)this.trans.getEndpoint().getRawKey(), this.klm.locatorCandidates((Comparable<?>)this.trans.getEndpoint().getRawKey()));
        try {
            req.post();
        }
        catch (Signaling.SignalingException e) {
            f.completeExceptionally(e);
        }
        return f;
    }

    public static void main(String[] args) {
        InetAddress[] inetAddressArray = DirectSignaling.getLocalAddresses();
        int n = inetAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress addr = inetAddressArray[n2];
            System.out.println(addr);
            ++n2;
        }
    }

    public static class AddressNotification
    extends Signaling.Request<NettyLocator[]> {
        public final Comparable<?> key;
        public final NettyLocator[] locs;

        public AddressNotification(Signaling sig, UdpPrimaryKey senderKey, NettyLocator dst, BiConsumer<Signaling.Response<NettyLocator[]>, ? super Throwable> consumer, Comparable<?> srcKey, NettyLocator[] srcLocs) {
            super(sig, senderKey, dst, consumer);
            this.key = srcKey;
            this.locs = srcLocs;
        }
    }

    public static class KeyRequest
    extends Signaling.Request<Comparable<?>> {
        public final Comparable<?> srcKey;
        public final Comparable<?> dstKey;

        public KeyRequest(Signaling sig, UdpPrimaryKey senderKey, NettyLocator dst, BiConsumer<Signaling.Response<Comparable<?>>, ? super Throwable> consumer, Comparable<?> srcKey, Comparable<?> dstKey) {
            super(sig, senderKey, dst, consumer);
            this.srcKey = srcKey;
            this.dstKey = dstKey;
        }
    }
}

