/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.udp.direct;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.udp.UdpLocatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyLocatorManager
implements UdpLocatorManager {
    ConcurrentHashMap<Comparable<?>, KeyLocatorEntry> map = new ConcurrentHashMap();
    protected static final Logger logger = LoggerFactory.getLogger(KeyLocatorManager.class);

    String inets2str(InetAddress[] inets) {
        String ret = "";
        InetAddress[] inetAddressArray = inets;
        int n = inets.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress inet = inetAddressArray[n2];
            ret = String.valueOf(ret) + "inet:" + inet.getHostAddress() + " ";
            ++n2;
        }
        return ret;
    }

    public void register(Comparable<?> key, InetAddress[] candidates, int port, boolean active) {
        KeyLocatorEntry kle = this.map.get(key);
        if (kle != null) {
            logger.debug("merging: {} : {} -> {}", new Object[]{active, key, this.inets2str(candidates)});
            kle.merge(new KeyLocatorEntry(key, candidates, port, true), active);
        } else {
            logger.debug("putting: {} -> {} ", key, (Object)this.inets2str(candidates));
            this.map.put(key, new KeyLocatorEntry(key, candidates, port, active));
        }
    }

    public void register(Comparable<?> key, InetAddress[] candidates, int port) {
        this.register(key, candidates, port, false);
    }

    public void register(Comparable<?> key, NettyLocator[] candidates) {
        KeyLocatorEntry kle = this.map.get(key);
        if (kle != null) {
            logger.debug("merging: {} -> {}", key, (Object)candidates);
            kle.merge(new KeyLocatorEntry(key, candidates), false);
        } else {
            logger.debug("putting: {} -> {}", key, (Object)candidates);
            this.map.put(key, new KeyLocatorEntry(key, candidates));
        }
    }

    public void registerActive(Comparable<?> key, NettyLocator candidate) {
        InetAddress[] candidates = new InetAddress[1];
        try {
            candidates[0] = InetAddress.getByName(candidate.getHost());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.register(key, candidates, candidate.getPort(), true);
    }

    public void registerActive(Comparable<?> key, InetSocketAddress candidate) {
        InetAddress[] candidates = new InetAddress[]{candidate.getAddress()};
        this.register(key, candidates, candidate.getPort(), true);
    }

    public void accessed(Comparable<?> key, NettyLocator loc) {
        KeyLocatorEntry kle = this.map.get(key);
        if (kle != null) {
            kle.accessed(loc);
        }
        kle.sort();
    }

    public LocatorEntry nextTrialCandidate(Comparable<?> key) {
        KeyLocatorEntry kle = this.map.get(key);
        if (kle != null) {
            return kle.nextTrialCandidate();
        }
        return null;
    }

    public List<LocatorEntry> candidates(Comparable<?> key) {
        KeyLocatorEntry kle = this.map.get(key);
        if (kle != null) {
            return kle.candidates();
        }
        return null;
    }

    @Override
    public NettyLocator[] locatorCandidates(Comparable<?> key) {
        KeyLocatorEntry kle = this.map.get(key);
        if (kle != null) {
            NettyLocator[] locs = new NettyLocator[kle.candidates().size()];
            int i = 0;
            while (i < kle.candidates().size()) {
                locs[i] = kle.candidates().get((int)i).locator;
                ++i;
            }
            return locs;
        }
        return null;
    }

    @Override
    public NettyLocator getPrimaryLocator(Comparable<?> key) {
        KeyLocatorEntry kle = this.map.get(key);
        return kle == null ? null : kle.getPrimaryEntry().locator;
    }

    public NettyLocator[] getLocatorsArray(Comparable<?> key) {
        KeyLocatorEntry kle = this.map.get(key);
        return kle == null ? null : kle.getLocatorsArray();
    }

    public KeyLocatorEntry getKeyLocatorEntry(Comparable<?> key) {
        return this.map.get(key);
    }

    @Override
    public String dump() {
        String ret = "----entries begin----";
        for (Map.Entry<Comparable<?>, KeyLocatorEntry> ent : this.map.entrySet()) {
            ret = String.valueOf(ret) + ent.getKey() + "->" + ent.getValue();
        }
        ret = String.valueOf(ret) + "----entries end----";
        return ret;
    }

    public static void main(String[] args) throws Exception {
        KeyLocatorManager klm = new KeyLocatorManager();
        InetAddress[] candidates = new InetAddress[4];
        byte[] byArray = new byte[4];
        byArray[0] = -64;
        byArray[1] = -88;
        byArray[3] = 1;
        candidates[0] = InetAddress.getByAddress(byArray);
        candidates[1] = InetAddress.getByAddress(new byte[]{-84, 16, 1, 1});
        candidates[2] = InetAddress.getByAddress(new byte[]{-84, 17, 1, 105});
        candidates[3] = InetAddress.getLoopbackAddress();
        klm.register(Integer.valueOf(1), candidates, 10080);
        klm.accessed(Integer.valueOf(1), new NettyLocator(candidates[0], 10080));
        Thread.sleep(10L);
        klm.accessed(Integer.valueOf(1), new NettyLocator(candidates[1], 10080));
        klm.accessed(Integer.valueOf(1), new NettyLocator(candidates[3], 10080));
        System.out.println(klm.candidates(Integer.valueOf(1)));
        InetAddress[] candidates2 = new InetAddress[4];
        byte[] byArray2 = new byte[4];
        byArray2[0] = -64;
        byArray2[1] = -88;
        byArray2[3] = 1;
        candidates2[0] = InetAddress.getByAddress(byArray2);
        candidates2[1] = InetAddress.getByAddress(new byte[]{-84, 16, 1, 1});
        candidates2[2] = InetAddress.getByAddress(new byte[]{-64, -88, 1, 1});
        candidates2[3] = InetAddress.getLoopbackAddress();
        klm.register(Integer.valueOf(1), candidates2, 10080);
        Thread.sleep(10L);
        System.out.println(klm.candidates(Integer.valueOf(1)));
        klm.accessed(Integer.valueOf(1), new NettyLocator(candidates[0], 10080));
        System.out.println(klm.candidates(Integer.valueOf(1)));
        klm.accessed(Integer.valueOf(1), new NettyLocator(candidates[3], 10080));
        System.out.println(klm.candidates(Integer.valueOf(1)));
    }

    public static class KeyLocatorEntry {
        public final Comparable<?> key;
        public final List<LocatorEntry> entries;

        public KeyLocatorEntry(Comparable<?> key) {
            this.key = key;
            this.entries = new ArrayList<LocatorEntry>();
        }

        public KeyLocatorEntry(Comparable<?> key, NettyLocator[] candidates) {
            this.key = key;
            this.entries = new ArrayList<LocatorEntry>();
            NettyLocator[] nettyLocatorArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                NettyLocator loc = nettyLocatorArray[n2];
                this.entries.add(new LocatorEntry(loc){
                    {
                        this.locator = nettyLocator;
                        this.lastAccessed = -1L;
                        this.rtt = Long.MAX_VALUE;
                    }
                });
                ++n2;
            }
        }

        LocatorEntry getPrimaryEntry() {
            return this.entries.get(0);
        }

        public NettyLocator[] getLocatorsArray() {
            NettyLocator[] ret = new NettyLocator[this.entries.size()];
            int i = 0;
            while (i < this.entries.size()) {
                ret[i] = this.entries.get((int)i).locator;
                ++i;
            }
            return ret;
        }

        public KeyLocatorEntry(Comparable<?> key, InetAddress[] candidates, int port, boolean active) {
            this.key = key;
            this.entries = new ArrayList<LocatorEntry>();
            InetAddress[] inetAddressArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress addr = inetAddressArray[n2];
                this.entries.add(new LocatorEntry(addr, port, active){
                    {
                        this.locator = new NettyLocator(NettyLocator.TYPE.UDP, inetAddress, n);
                        this.lastAccessed = bl ? System.currentTimeMillis() : -1L;
                        this.rtt = Long.MAX_VALUE;
                    }
                });
                ++n2;
            }
        }

        public void sort() {
            Collections.sort(this.entries, (x, y) -> {
                int cmp = 0;
                cmp = Long.valueOf(x.rtt).compareTo(y.rtt);
                if (cmp != 0) {
                    return cmp;
                }
                return Long.valueOf(y.lastAccessed).compareTo(x.lastAccessed);
            });
        }

        public LocatorEntry accessed(NettyLocator loc) {
            for (LocatorEntry addr : this.entries) {
                if (!loc.equals(addr.locator)) continue;
                addr.lastAccessed = System.currentTimeMillis();
                return addr;
            }
            return null;
        }

        public LocatorEntry accessed(NettyLocator loc, long rtt) {
            for (LocatorEntry addr : this.entries) {
                if (!loc.equals(addr.locator)) continue;
                addr.lastAccessed = System.currentTimeMillis();
                addr.rtt = rtt;
                return addr;
            }
            return null;
        }

        public void add(InetSocketAddress addr) {
            this.entries.add(new LocatorEntry(addr){
                {
                    this.locator = new NettyLocator(NettyLocator.TYPE.UDP, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.lastAccessed = -1L;
                    this.rtt = Long.MAX_VALUE;
                }
            });
        }

        public LocatorEntry nextTrialCandidate() {
            this.sort();
            assert (this.entries.size() != 0);
            return this.entries.get(this.entries.size() - 1);
        }

        public List<LocatorEntry> candidates() {
            return this.entries;
        }

        public void merge(KeyLocatorEntry ent, boolean active) {
            assert (this.key.equals(ent.key)) : "not match: " + this.key + "!=" + ent.key;
            ArrayList<LocatorEntry> missing = null;
            for (LocatorEntry oaddr : ent.entries) {
                boolean found = false;
                for (LocatorEntry addr : this.entries) {
                    if (!addr.locator.equals(oaddr.locator)) continue;
                    found = true;
                    if (!active) break;
                    addr.lastAccessed = System.currentTimeMillis();
                    break;
                }
                if (found) continue;
                if (missing == null) {
                    missing = new ArrayList<LocatorEntry>();
                }
                oaddr.lastAccessed = active ? System.currentTimeMillis() : -1L;
                missing.add(oaddr);
            }
            if (missing != null) {
                this.entries.addAll(missing);
            }
            this.sort();
            logger.debug("after merged({}):{}", this.key, this.entries);
        }

        public String toString() {
            return "key=" + this.key + ",ents=" + this.entries;
        }
    }

    public static class LocatorEntry {
        public NettyLocator locator;
        public long lastAccessed;
        public long rtt;
        public Comparable<?> source;

        public String toString() {
            return this.locator + "/lastAccessed=" + this.lastAccessed + "/rtt=" + this.rtt + "/src=" + this.source;
        }
    }
}

