/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov;

import java.io.Serializable;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;

public class Link
implements Cloneable,
Serializable,
Comparable<Link> {
    private static final long serialVersionUID = 1L;
    public final Endpoint addr;
    public final DdllKey key;
    private final int hash;

    public Link(Endpoint node, DdllKey key) {
        this.addr = node;
        if (node == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.hash = this.addr.hashCode() ^ key.hashCode2();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Link)) {
            return false;
        }
        Link another = (Link)o;
        return this.addr.equals(another.addr) && this.key.compareTo(another.key) == 0;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(Link another) {
        return this.key.compareTo(another.key);
    }

    public synchronized Object clone() {
        try {
            Link t = (Link)super.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        String s = this.addr.toString();
        if (s.startsWith("127.0.0.1:")) {
            s = s.substring(9);
        }
        return String.valueOf(this.key.toString()) + "@" + s;
    }

    public Link getIdChangedLink(String id) {
        return new Link(this.addr, this.key.getIdChangedKey(id));
    }
}

